/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.kit.datecalc.jdk8;

import java.time.LocalDate;
import net.objectlab.kit.datecalc.common.CurrencyDateCalculatorBuilder;
import net.objectlab.kit.datecalc.common.ccy.AbstractCurrencyDateCalculator;
import net.objectlab.kit.datecalc.jdk8.Jdk8WorkingWeek;

public class LocalDateCurrencyDateCalculator
extends AbstractCurrencyDateCalculator<LocalDate> {
    public LocalDateCurrencyDateCalculator(CurrencyDateCalculatorBuilder<LocalDate> builder) {
        super(builder);
    }

    @Override
    protected LocalDate addMonths(LocalDate calc, int unit) {
        return calc.plusMonths(unit);
    }

    @Override
    protected LocalDate calculateNextDay(LocalDate date) {
        return date.plusDays(1L);
    }

    @Override
    protected int calendarWeekDay(LocalDate date) {
        return Jdk8WorkingWeek.jdk8ToCalendarDayConstant(date.getDayOfWeek());
    }

    @Override
    protected LocalDate max(LocalDate d1, LocalDate d2) {
        return d1.isAfter(d2) ? d1 : d2;
    }
}

