/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.bytes.HeapBytesStore;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.bytes.PointerBytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.RandomDataOutput;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.ReferenceCounted;
import net.openhft.chronicle.core.io.IORuntimeException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BytesStore<B extends BytesStore<B, Underlying>, Underlying>
extends RandomDataInput,
RandomDataOutput<B>,
ReferenceCounted,
CharSequence {
    public static BytesStore from(@NotNull CharSequence cs) {
        if (cs instanceof BytesStore) {
            return ((BytesStore)cs).copy();
        }
        return BytesStore.wrap(cs.toString().getBytes(StandardCharsets.ISO_8859_1));
    }

    public static HeapBytesStore<byte[]> wrap(@NotNull byte[] bytes) {
        return HeapBytesStore.wrap(bytes);
    }

    @NotNull
    public static BytesStore<?, ByteBuffer> wrap(@NotNull ByteBuffer bb) {
        return bb.isDirect() ? NativeBytesStore.wrap(bb) : HeapBytesStore.wrap(bb);
    }

    @NotNull
    public static PointerBytesStore nativePointer() {
        return new PointerBytesStore();
    }

    @NotNull
    public static PointerBytesStore wrap(long address, long length) {
        PointerBytesStore pbs = BytesStore.nativePointer();
        pbs.set(address, length);
        return pbs;
    }

    public static BytesStore empty() {
        return NoBytesStore.noBytesStore();
    }

    @Override
    public boolean isDirectMemory();

    public BytesStore<B, Underlying> copy() throws IllegalArgumentException;

    @Override
    @NotNull
    default public Bytes<Underlying> bytesForRead() throws IllegalStateException {
        return (Bytes)this.bytesForWrite().readLimit(this.writeLimit());
    }

    @Override
    @NotNull
    default public Bytes<Underlying> bytesForWrite() throws IllegalStateException {
        return new VanillaBytes(this, this.writePosition(), this.writeLimit());
    }

    default public boolean isClear() {
        return true;
    }

    @Override
    default public long realCapacity() {
        return this.capacity();
    }

    @Override
    public long capacity();

    @Nullable
    public Underlying underlyingObject();

    default public boolean inside(long offset) {
        return this.start() <= offset && offset < this.safeLimit();
    }

    default public long safeLimit() {
        return this.capacity();
    }

    default public long copyTo(@NotNull BytesStore store) throws IllegalStateException {
        long i;
        long readPos = this.readPosition();
        long writePos = store.writePosition();
        long copy = Math.min(this.readRemaining(), store.capacity());
        for (i = 0L; i < copy - 7L; i += 8L) {
            store.writeLong(writePos + i, this.readLong(readPos + i));
        }
        while (i < copy) {
            store.writeByte(writePos + i, this.readByte(readPos + i));
            ++i;
        }
        return copy;
    }

    default public void copyTo(@NotNull OutputStream out) throws IOException {
        BytesInternal.copy(this, out);
    }

    @Override
    @NotNull
    default public B zeroOut(long start, long end) throws IllegalArgumentException {
        long i;
        if (end <= start) {
            return (B)this;
        }
        if (start < this.start()) {
            throw new IllegalArgumentException(start + " < " + this.start());
        }
        if (end > this.capacity()) {
            throw new IllegalArgumentException(end + " > " + this.capacity());
        }
        for (i = start; i < end - 7L; i += 8L) {
            this.writeLong(i, 0L);
        }
        while (i < end) {
            this.writeByte(i, 0);
            ++i;
        }
        return (B)this;
    }

    @Override
    default public int length() {
        return (int)Math.min(Integer.MAX_VALUE, this.readRemaining());
    }

    @Override
    default public char charAt(int index) throws IndexOutOfBoundsException {
        try {
            return (char)this.readUnsignedByte(this.readPosition() + (long)index);
        }
        catch (BufferUnderflowException e) {
            throw new IndexOutOfBoundsException(this.readPosition() + (long)index + " >= " + this.readLimit());
        }
    }

    @Override
    @NotNull
    default public CharSequence subSequence(int start, int end) {
        throw new UnsupportedOperationException("todo");
    }

    @NotNull
    default public String toDebugString() {
        return this.toDebugString(512L);
    }

    @NotNull
    default public String toDebugString(long maxLength) {
        return BytesInternal.toDebugString(this, maxLength);
    }

    @Nullable
    default public BytesStore bytesStore() {
        return this;
    }

    default public boolean equalBytes(@NotNull BytesStore bytesStore, long length) throws BufferUnderflowException {
        return length == 8L ? this.readLong(this.readPosition()) == bytesStore.readLong(bytesStore.readPosition()) : BytesInternal.equalBytesAny(this, bytesStore, length);
    }

    default public int byteCheckSum() throws IORuntimeException {
        int b = 0;
        for (long i = this.readPosition(); i < this.readLimit(); ++i) {
            b = (byte)(b + this.readByte(i));
        }
        return b & 0xFF;
    }

    default public long longCheckSum() {
        long i;
        long sum = 0L;
        for (i = this.readPosition(); i < this.readLimit() - 7L; i += 8L) {
            sum += this.readLong(i);
        }
        if (i < this.readLimit()) {
            sum += this.readIncompleteLong(i);
        }
        return sum;
    }

    default public boolean endsWith(char c) {
        return this.readRemaining() > 0L && this.readUnsignedByte(this.readLimit() - 1L) == c;
    }

    default public boolean startsWith(char c) {
        return this.readRemaining() > 0L && this.readUnsignedByte(this.readPosition()) == c;
    }

    default public boolean contentEquals(@Nullable BytesStore bytesStore) {
        return BytesInternal.contentEqual(this, bytesStore);
    }

    default public boolean startsWith(@Nullable BytesStore bytesStore) {
        return BytesInternal.startsWith(this, bytesStore);
    }

    @NotNull
    default public String to8bitString() throws IllegalArgumentException {
        return BytesInternal.to8bitString(this);
    }

    default public byte addAndGetByteNotAtomic(long offset, byte adding) {
        byte r = (byte)(this.readByte(offset) + adding);
        this.writeByte(offset, r);
        return r;
    }

    default public int addAndGetUnsignedByteNotAtomic(long offset, int adding) {
        int r = this.readUnsignedByte(offset) + adding & 0xFF;
        this.writeByte(offset, (byte)r);
        return r;
    }

    default public short addAndGetShortNotAtomic(long offset, short adding) {
        short r = (short)(this.readShort(offset) + adding);
        this.writeByte(offset, r);
        return r;
    }

    default public int addAndGetUnsignedShortNotAtomic(long offset, int adding) {
        int r = this.readUnsignedShort(offset) + adding & 0xFFFF;
        this.writeShort(offset, (short)r);
        return r;
    }

    default public int addAndGetIntNotAtomic(long offset, int adding) {
        int r = this.readInt(offset) + adding;
        this.writeInt(offset, r);
        return r;
    }

    default public long addAndGetUnsignedIntNotAtomic(long offset, long adding) {
        long r = this.readUnsignedInt(offset) + adding & 0xFFFFFFFFL;
        this.writeInt(offset, (int)r);
        return r;
    }

    default public long addAndGetLongNotAtomic(long offset, long adding) {
        long r = this.readLong(offset) + adding;
        this.writeLong(offset, r);
        return r;
    }

    default public float addAndGetFloatNotAtomic(long offset, float adding) {
        float r = this.readFloat(offset) + adding;
        this.writeFloat(offset, r);
        return r;
    }

    default public double addAndGetDoubleNotAtomic(long offset, double adding) {
        double r = this.readDouble(offset) + adding;
        this.writeDouble(offset, r);
        return r;
    }

    default public void isPresent(boolean isPresent) {
        if (!isPresent) {
            throw new IllegalArgumentException("isPresent=false not supported");
        }
    }

    default public boolean isPresent() {
        return true;
    }

    public void move(long var1, long var3, long var5);

    default public void writeMaxLong(long offset, long atLeast) {
        long v;
        do {
            if ((v = this.readVolatileLong(offset)) < atLeast) continue;
            return;
        } while (!this.compareAndSwapLong(offset, v, atLeast));
    }

    @Override
    default public boolean isEmpty() {
        return this.readRemaining() == 0L;
    }

    default public void cipher(@NotNull Cipher cipher, @NotNull Bytes outBytes, @NotNull ByteBuffer using1, @NotNull ByteBuffer using2) {
        long readPos = outBytes.readPosition();
        try {
            NativeBytesStore<Void> inBytes;
            long writePos = outBytes.writePosition();
            long size = this.readRemaining();
            if (this.isDirectMemory()) {
                inBytes = this;
            } else {
                inBytes = NativeBytesStore.nativeStore(size);
                this.copyTo(inBytes);
            }
            BytesInternal.assignBytesStoreToByteBuffer(inBytes, using1);
            int outputSize = cipher.getOutputSize(Math.toIntExact(size));
            outBytes.ensureCapacity(writePos + (long)outputSize);
            outBytes.readPositionRemaining(writePos, outputSize);
            BytesInternal.assignBytesStoreToByteBuffer(outBytes, using2);
            int len = cipher.update(using1, using2);
            if (!1.$assertionsDisabled && (len += cipher.doFinal(using1, using2)) != using2.position()) {
                throw new AssertionError();
            }
            outBytes.writePosition(writePos + (long)using2.position());
        }
        catch (BadPaddingException | IllegalBlockSizeException | ShortBufferException e) {
            throw new IllegalStateException(e);
        }
        finally {
            outBytes.readPosition(readPos);
        }
    }

    default public void cipher(@NotNull Cipher cipher, @NotNull Bytes outBytes) {
        this.cipher(cipher, outBytes, BytesInternal.BYTE_BUFFER_TL.get(), BytesInternal.BYTE_BUFFER2_TL.get());
    }

    default public boolean readWrite() {
        return true;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

