/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.pool;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ClassAliasPool {
    private final Map<String, Class> stringClassMap = new ConcurrentHashMap<String, Class>();
    private final Map<String, Class> stringClassMap2 = new ConcurrentHashMap<String, Class>();
    private final Map<Class, String> classStringMap = new ConcurrentHashMap<Class, String>();
    public static final ClassAliasPool CLASS_ALIASES = new ClassAliasPool().defaultAliases();

    private ClassAliasPool defaultAliases() {
        this.addAlias(Set.class);
        this.addAlias(String.class);
        this.addAlias(CharSequence.class);
        this.addAlias(Byte.class, "Byte, int8");
        this.addAlias(Character.class, "Char");
        this.addAlias(Integer.class, "int32");
        this.addAlias(Long.class, "Int, int64");
        this.addAlias(Float.class, "Float32");
        this.addAlias(Double.class, "Float64");
        this.addAlias(LocalDate.class, "Date");
        this.addAlias(LocalDateTime.class, "DateTime");
        this.addAlias(LocalTime.class, "Time");
        return this;
    }

    public void clean() {
        this.clean(this.stringClassMap.values());
        this.clean(this.stringClassMap2.values());
        this.clean(this.classStringMap.keySet());
    }

    private void clean(Iterable<Class> coll) {
        ClassLoader classLoader2 = ClassAliasPool.class.getClassLoader();
        Iterator<Class> iter = coll.iterator();
        while (iter.hasNext()) {
            Class clazz = iter.next();
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader == null || classLoader == classLoader2) continue;
            iter.remove();
        }
    }

    public Class forName(CharSequence name) throws IllegalArgumentException {
        String name0 = name.toString();
        Class clazz = this.stringClassMap.get(name0);
        return clazz != null ? clazz : this.stringClassMap2.computeIfAbsent(name0, n -> {
            try {
                return Class.forName(name0);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        });
    }

    public String nameFor(Class clazz) {
        if (Enum.class.isAssignableFrom(clazz)) {
            clazz = clazz.getEnclosingClass();
        }
        return this.classStringMap.computeIfAbsent(clazz, Class::getName);
    }

    public void addAlias(Class ... classes) {
        for (Class clazz : classes) {
            this.stringClassMap.putIfAbsent(clazz.getName(), clazz);
            this.stringClassMap2.putIfAbsent(clazz.getSimpleName(), clazz);
            this.stringClassMap2.putIfAbsent(this.toCamelCase(clazz.getSimpleName()), clazz);
            this.classStringMap.computeIfAbsent(clazz, Class::getSimpleName);
        }
    }

    private String toCamelCase(String name) {
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    public void addAlias(Class clazz, String names) {
        for (String name : names.split(", ?")) {
            this.stringClassMap.put(name, clazz);
            this.stringClassMap2.putIfAbsent(this.toCamelCase(name), clazz);
            this.classStringMap.putIfAbsent(clazz, name);
            this.addAlias(clazz);
        }
    }
}

