/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CloseablesManager
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger((String)CloseablesManager.class.getName());
    private final List<Closeable> closeables = new ArrayList<Closeable>();

    public synchronized void add(Closeable closeable) {
        if (closeable == null) {
            throw new NullPointerException();
        }
        if (!this.closeables.contains(closeable)) {
            this.closeables.add(closeable);
        }
    }

    public synchronized void close(Closeable closeable) throws IOException {
        this.closeables.remove(closeable);
        closeable.close();
    }

    public synchronized void closeQuietly(Closeable closeable) {
        try {
            this.close(closeable);
        }
        catch (IOException e) {
            LOG.error("", (Throwable)e);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        IOException ex = null;
        for (int i = this.closeables.size() - 1; i >= 0; --i) {
            Closeable closeable = this.closeables.get(i);
            try {
                closeable.close();
                continue;
            }
            catch (NullPointerException e) {
                LOG.debug("", (Throwable)e);
                continue;
            }
            catch (IOException e) {
                LOG.debug("", (Throwable)e);
                ex = e;
            }
        }
        this.closeables.clear();
        if (ex != null) {
            throw ex;
        }
    }

    public synchronized void closeQuietly() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized boolean isEmpty() {
        return this.closeables.isEmpty();
    }
}

