/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.pool;

import java.util.function.Function;
import java.util.stream.Stream;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.util.StringUtils;
import org.jetbrains.annotations.Nullable;

public class ParsingCache<E> {
    protected final ParsedData<E>[] interner;
    protected final int mask;
    protected final int shift;
    private final Function<String, E> eFunction;
    protected boolean toggle = false;

    public ParsingCache(int capacity, Function<String, E> eFunction) throws IllegalArgumentException {
        this.eFunction = eFunction;
        int n = Maths.nextPower2(capacity, 128);
        this.shift = Maths.intLog2(n);
        this.interner = new ParsedData[n];
        this.mask = n - 1;
    }

    @Nullable
    public E intern(@Nullable CharSequence cs) {
        if (cs == null) {
            return null;
        }
        int hash = Maths.hash32(cs);
        int h = hash & this.mask;
        ParsedData<E> s = this.interner[h];
        if (s != null && StringUtils.isEqual(s.string, cs)) {
            return s.e;
        }
        int h2 = hash >> this.shift & this.mask;
        ParsedData<E> s2 = this.interner[h2];
        if (s2 != null && StringUtils.isEqual(s2.string, cs)) {
            return s2.e;
        }
        String string = cs.toString();
        ParsedData<E> s3 = new ParsedData<E>(string, this.eFunction.apply(string));
        this.interner[s == null || s2 != null && this.toggle() ? h : h2] = s3;
        return s3.e;
    }

    protected boolean toggle() {
        this.toggle = !this.toggle;
        return this.toggle;
    }

    public int valueCount() {
        return (int)Stream.of(this.interner).filter(s -> s != null).count();
    }

    static class ParsedData<E> {
        final String string;
        final E e;

        ParsedData(String string, E e) {
            this.string = string;
            this.e = e;
        }
    }
}

