/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.lang.reflect.Field;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.annotation.ForceInline;
import net.openhft.chronicle.core.annotation.NotNull;
import org.jetbrains.annotations.Nullable;

public enum StringUtils {

    private static final Field S_VALUE;
    private static final Field SB_COUNT;
    private static final long S_VALUE_OFFSET;
    private static final long SB_VALUE_OFFSET;
    private static final long SB_COUNT_OFFSET;
    private static final long S_COUNT_OFFSET;
    private static final long MAX_VALUE_DIVIDE_10 = 0xCCCCCCCCCCCCCCCL;

    public static void setLength(@org.jetbrains.annotations.NotNull StringBuilder sb, int length) {
        try {
            SB_COUNT.set(sb, length);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void set(@org.jetbrains.annotations.NotNull StringBuilder sb, CharSequence cs) {
        sb.setLength(0);
        sb.append(cs);
    }

    public static boolean endsWith(@org.jetbrains.annotations.NotNull CharSequence source, @org.jetbrains.annotations.NotNull String endsWith) {
        for (int i = 1; i <= endsWith.length(); ++i) {
            if (Character.toLowerCase(source.charAt(source.length() - i)) == Character.toLowerCase(endsWith.charAt(endsWith.length() - i))) continue;
            return false;
        }
        return true;
    }

    @ForceInline
    public static boolean isEqual(@Nullable CharSequence s, @Nullable CharSequence cs) {
        int csLength;
        if (s instanceof StringBuilder) {
            return StringUtils.isEqual((StringBuilder)s, cs);
        }
        if (s == cs) {
            return true;
        }
        if (s == null) {
            return false;
        }
        if (cs == null) {
            return false;
        }
        int sLength = s.length();
        if (sLength != (csLength = cs.length())) {
            return false;
        }
        for (int i = 0; i < csLength; ++i) {
            if (s.charAt(i) == cs.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @ForceInline
    public static boolean isEqual(@Nullable StringBuilder s, @Nullable CharSequence cs) {
        if (s == cs) {
            return true;
        }
        if (s == null) {
            return false;
        }
        if (cs == null) {
            return false;
        }
        int length = cs.length();
        if (s.length() != length) {
            return false;
        }
        if (Jvm.isJava9Plus()) {
            for (int i = 0; i < length; ++i) {
                if (s.charAt(i) == cs.charAt(i)) continue;
                return false;
            }
            return true;
        }
        char[] chars = StringUtils.extractChars(s);
        for (int i = 0; i < length; ++i) {
            if (chars[i] == cs.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @ForceInline
    public static boolean equalsCaseIgnore(@Nullable CharSequence s, @org.jetbrains.annotations.NotNull CharSequence cs) {
        if (s == null) {
            return false;
        }
        if (s.length() != cs.length()) {
            return false;
        }
        for (int i = 0; i < cs.length(); ++i) {
            if (Character.toLowerCase(s.charAt(i)) == Character.toLowerCase(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @ForceInline
    @Nullable
    public static String toString(@Nullable Object o) {
        return o == null ? null : o.toString();
    }

    public static char[] extractChars(StringBuilder sb) {
        if (Jvm.isJava9Plus()) {
            char[] data = new char[sb.length()];
            sb.getChars(0, sb.length(), data, 0);
            return data;
        }
        return (char[])OS.memory().getObject(sb, SB_VALUE_OFFSET);
    }

    public static byte getStringCoder(@org.jetbrains.annotations.NotNull String str) {
        return StringUtils.getStringCoderForStringOrStringBuilder(str);
    }

    public static byte getStringCoder(@org.jetbrains.annotations.NotNull StringBuilder str) {
        return StringUtils.getStringCoderForStringOrStringBuilder(str);
    }

    private static byte getStringCoderForStringOrStringBuilder(@org.jetbrains.annotations.NotNull CharSequence charSequence) {
        try {
            return Jvm.getField(charSequence.getClass(), "coder").getByte(charSequence);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static byte[] extractBytes(@org.jetbrains.annotations.NotNull StringBuilder sb) {
        StringUtils.ensureJava9Plus();
        return (byte[])OS.memory().getObject(sb, SB_VALUE_OFFSET);
    }

    public static char[] extractChars(@org.jetbrains.annotations.NotNull String s) {
        if (Jvm.isJava9Plus()) {
            return s.toCharArray();
        }
        return (char[])OS.memory().getObject(s, S_VALUE_OFFSET);
    }

    public static byte[] extractBytes(@org.jetbrains.annotations.NotNull String s) {
        StringUtils.ensureJava9Plus();
        return (byte[])OS.memory().getObject(s, S_VALUE_OFFSET);
    }

    public static void setCount(@org.jetbrains.annotations.NotNull StringBuilder sb, int count) {
        OS.memory().writeInt(sb, SB_COUNT_OFFSET, count);
    }

    @org.jetbrains.annotations.NotNull
    public static String newString(@org.jetbrains.annotations.NotNull char[] chars) {
        if (Jvm.isJava9Plus()) {
            return new String(chars);
        }
        String str = new String();
        try {
            S_VALUE.set(str, chars);
            if (S_COUNT_OFFSET > -1L) {
                OS.memory().writeInt(str, S_COUNT_OFFSET, chars.length);
            }
            return str;
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    @org.jetbrains.annotations.NotNull
    public static String newStringFromBytes(@org.jetbrains.annotations.NotNull byte[] bytes) {
        StringUtils.ensureJava9Plus();
        String str = new String();
        try {
            S_VALUE.set(str, bytes);
            return str;
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    @Nullable
    public static String firstLowerCase(@Nullable String str) {
        char c2;
        if (str == null || str.isEmpty()) {
            return str;
        }
        char ch = str.charAt(0);
        return ch == (c2 = Character.toLowerCase(ch)) ? str : c2 + str.substring(1);
    }

    public static double parseDouble(@org.jetbrains.annotations.NotNull @NotNull CharSequence in) {
        long value = 0L;
        int exp = 0;
        boolean negative = false;
        int decimalPlaces = Integer.MIN_VALUE;
        char ch = in.charAt(0);
        int pos = 1;
        switch (ch) {
            case 'N': {
                if (StringUtils.compareRest(in, 1, "aN")) {
                    return Double.NaN;
                }
                return Double.NaN;
            }
            case 'I': {
                if (StringUtils.compareRest(in, 1, "nfinity")) {
                    return Double.POSITIVE_INFINITY;
                }
                return Double.NaN;
            }
            case '-': {
                if (StringUtils.compareRest(in, 1, "Infinity")) {
                    return Double.NEGATIVE_INFINITY;
                }
                negative = true;
                ch = in.charAt(pos++);
            }
        }
        while (true) {
            if (ch >= '0' && ch <= '9') {
                while (value >= 0xCCCCCCCCCCCCCCCL) {
                    value >>>= 1;
                    ++exp;
                }
                value = value * 10L + (long)(ch - 48);
                ++decimalPlaces;
            } else {
                if (ch != '.') break;
                decimalPlaces = 0;
            }
            if (pos == in.length()) break;
            ch = in.charAt(pos++);
        }
        return StringUtils.asDouble(value, exp, negative, decimalPlaces);
    }

    private static void ensureJava9Plus() {
        if (!Jvm.isJava9Plus()) {
            throw new UnsupportedOperationException("This method is only supported on Java9+ runtimes");
        }
    }

    private static boolean compareRest(@org.jetbrains.annotations.NotNull @NotNull CharSequence in, int pos, @org.jetbrains.annotations.NotNull @NotNull String s) {
        if (s.length() > in.length() - pos) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (in.charAt(i + pos) == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static double asDouble(long value, int exp, boolean negative, int decimalPlaces) {
        if (decimalPlaces > 0 && value < 0x3FFFFFFFFFFFFFFFL) {
            if (value < Integer.MAX_VALUE) {
                exp -= 32;
                value <<= 32;
            }
            if (value < 0x7FFFFFFFFFFFL) {
                exp -= 16;
                value <<= 16;
            }
            if (value < 0x7FFFFFFFFFFFFFL) {
                exp -= 8;
                value <<= 8;
            }
            if (value < 0x7FFFFFFFFFFFFFFL) {
                exp -= 4;
                value <<= 4;
            }
            if (value < 0x1FFFFFFFFFFFFFFFL) {
                exp -= 2;
                value <<= 2;
            }
            if (value < 0x3FFFFFFFFFFFFFFFL) {
                --exp;
                value <<= 1;
            }
        }
        while (decimalPlaces > 0) {
            --exp;
            long mod = value % 5L;
            int modDiv = 1;
            if ((value /= 5L) < 0x7FFFFFFFFFFFFFFL) {
                exp -= 4;
                value <<= 4;
                modDiv <<= 4;
            }
            if (value < 0x1FFFFFFFFFFFFFFFL) {
                exp -= 2;
                value <<= 2;
                modDiv <<= 2;
            }
            if (value < 0x3FFFFFFFFFFFFFFFL) {
                --exp;
                value <<= 1;
                modDiv <<= 1;
            }
            value = decimalPlaces > 1 ? (value += (long)modDiv * mod / 5L) : (value += ((long)modDiv * mod + 4L) / 5L);
            --decimalPlaces;
        }
        double d = Math.scalb((double)value, exp);
        return negative ? -d : d;
    }

    @Nullable
    public static String toTitleCase(@Nullable String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Character.toUpperCase(name.charAt(0)));
        boolean wasUnder = false;
        for (int i = 1; i < name.length(); ++i) {
            char ch1;
            char ch0 = name.charAt(i);
            char c = ch1 = i + 1 < name.length() ? (char)name.charAt(i + 1) : (char)' ';
            if (Character.isLowerCase(ch0)) {
                sb.append(Character.toUpperCase(ch0));
                if (Character.isUpperCase(ch1)) {
                    sb.append('_');
                    wasUnder = true;
                    continue;
                }
                wasUnder = false;
                continue;
            }
            if (Character.isUpperCase(ch0)) {
                if (!wasUnder && Character.isLowerCase(ch1)) {
                    sb.append('_');
                }
                sb.append(ch0);
                wasUnder = false;
                continue;
            }
            sb.append(ch0);
            wasUnder = ch0 == '_';
        }
        return sb.toString();
    }

    public static void reverse(StringBuilder text, int start) {
        int end = text.length() - 1;
        int mid = (start + end + 1) / 2;
        for (int i = 0; i < mid - start; ++i) {
            char ch = text.charAt(start + i);
            text.setCharAt(start + i, text.charAt(end - i));
            text.setCharAt(end - i, ch);
        }
    }

    static {
        try {
            S_VALUE = String.class.getDeclaredField("value");
            Jvm.setAccessible(S_VALUE);
            S_VALUE_OFFSET = OS.memory().getFieldOffset(S_VALUE);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        long sCountOffset = -1L;
        try {
            Field sCount = String.class.getDeclaredField("count");
            Jvm.setAccessible(sCount);
            sCountOffset = OS.memory().getFieldOffset(sCount);
        }
        catch (Exception sCount) {
            // empty catch block
        }
        S_COUNT_OFFSET = sCountOffset;
        try {
            long sbCountOffset;
            Field sbCount;
            long sbValOffset;
            Field sbValue;
            try {
                sbValue = Class.forName("java.lang.AbstractStringBuilder").getDeclaredField("value");
                Jvm.setAccessible(sbValue);
                sbValOffset = OS.memory().getFieldOffset(sbValue);
                sbCount = Class.forName("java.lang.AbstractStringBuilder").getDeclaredField("count");
                Jvm.setAccessible(sbCount);
                sbCountOffset = OS.memory().getFieldOffset(sbCount);
            }
            catch (NoSuchFieldException e) {
                sbValue = Class.forName("java.lang.StringBuilder").getDeclaredField("value");
                Jvm.setAccessible(sbValue);
                sbValOffset = OS.memory().getFieldOffset(sbValue);
                sbCount = Class.forName("java.lang.StringBuilder").getDeclaredField("count");
                Jvm.setAccessible(sbCount);
                sbCountOffset = OS.memory().getFieldOffset(sbCount);
            }
            SB_COUNT = sbCount;
            SB_VALUE_OFFSET = sbValOffset;
            SB_COUNT_OFFSET = sbCountOffset;
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }
}

