/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.tcp.ISocketChannel;

public class VanillaSocketChannel
extends AbstractCloseable
implements ISocketChannel {
    protected final SocketChannel socketChannel;

    VanillaSocketChannel(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
    }

    @Override
    public SocketChannel socketChannel() {
        return this.socketChannel;
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        return this.socketChannel.read(byteBuffer);
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        return this.socketChannel.write(byteBuffer);
    }

    @Override
    public long write(ByteBuffer[] byteBuffer) throws IOException {
        return this.socketChannel.write(byteBuffer);
    }

    @Override
    public Socket socket() {
        return this.socketChannel.socket();
    }

    @Override
    public void configureBlocking(boolean blocking) throws IOException {
        this.socketChannel.configureBlocking(blocking);
    }

    @Override
    public InetSocketAddress getRemoteAddress() throws IORuntimeException {
        try {
            return (InetSocketAddress)this.socketChannel.getRemoteAddress();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    @Override
    public InetSocketAddress getLocalAddress() throws IORuntimeException {
        try {
            return (InetSocketAddress)this.socketChannel.getLocalAddress();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    @Override
    public boolean isOpen() {
        return this.socketChannel.isOpen();
    }

    @Override
    public boolean isBlocking() {
        return this.socketChannel.isBlocking();
    }

    @Override
    protected boolean performCloseInBackground() {
        return true;
    }

    @Override
    protected void performClose() {
        Closeable.closeQuietly((Object)this.socketChannel);
    }

    public String toString() {
        return "VanillaSocketChannel{socketChannel=" + this.socketChannel + '}';
    }

    protected boolean superThreadSafetyCheck() {
        return super.threadSafetyCheck();
    }

    @Override
    protected boolean threadSafetyCheck() {
        return true;
    }
}

