/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger.log4j2;

import java.io.IOException;
import net.openhft.chronicle.Chronicle;
import net.openhft.chronicle.ExcerptAppender;
import net.openhft.chronicle.VanillaChronicle;
import net.openhft.chronicle.logger.VanillaLogAppenderConfig;
import net.openhft.chronicle.logger.log4j2.AbstractChronicleAppender;
import net.openhft.chronicle.logger.log4j2.TextChronicleAppender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="TextVanillaChronicle", category="Core", elementType="appender", printObject=true)
public class TextVanillaChronicleAppender
extends TextChronicleAppender {
    private final VanillaLogAppenderConfig config;

    public TextVanillaChronicleAppender(String name, Filter filter, String path, VanillaLogAppenderConfig config) {
        super(name, filter, path);
        this.config = config;
    }

    @Override
    protected Chronicle createChronicle() throws IOException {
        return this.config != null ? new VanillaChronicle(this.getPath(), this.config.cfg()) : new VanillaChronicle(this.getPath());
    }

    @Override
    protected ExcerptAppender getAppender() {
        try {
            return this.chronicle.createAppender();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected VanillaLogAppenderConfig getChronicleConfig() {
        return this.config;
    }

    @PluginFactory
    public static TextVanillaChronicleAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="path") String path, @PluginAttribute(value="dateFormat") String dateFormat, @PluginAttribute(value="stackTraceDepth") String stackTraceDepth, @PluginElement(value="vanillaChronicleConfig") AbstractChronicleAppender.VanillaChronicleCfg chronicleConfig, @PluginElement(value="filter") Filter filter) {
        if (name == null) {
            LOGGER.error("No name provided for TextVanillaChronicleAppender");
            return null;
        }
        if (path == null) {
            LOGGER.error("No path provided for TextVanillaChronicleAppender");
            return null;
        }
        TextVanillaChronicleAppender appender = new TextVanillaChronicleAppender(name, filter, path, chronicleConfig);
        if (dateFormat != null) {
            appender.setDateFormat(dateFormat);
        }
        if (stackTraceDepth != null) {
            appender.setStackTraceDepth(Integer.parseInt(stackTraceDepth));
        }
        return appender;
    }
}

