/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.openhft.chronicle.Chronicle;
import net.openhft.chronicle.IndexedChronicle;
import net.openhft.chronicle.logger.ChronicleLogConfig;
import net.openhft.chronicle.logger.ChronicleLogWriter;
import net.openhft.chronicle.logger.ChronicleLogWriters;

public class ChronicleLogManager {
    private ChronicleLogConfig cfg = ChronicleLogConfig.load();
    private Map<String, ChronicleLogWriter> writers = new ConcurrentHashMap<String, ChronicleLogWriter>();

    private ChronicleLogManager() {
    }

    public ChronicleLogConfig cfg() {
        return this.cfg;
    }

    public void clear() {
        for (ChronicleLogWriter writer : this.writers.values()) {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
        this.writers.clear();
    }

    public void reload() {
        this.clear();
        this.cfg = ChronicleLogConfig.load();
        this.writers = new ConcurrentHashMap<String, ChronicleLogWriter>();
    }

    public boolean isBinary(String name) {
        return "binary".equalsIgnoreCase(this.cfg.getString(name, "format"));
    }

    public boolean isText(String name) {
        return "text".equalsIgnoreCase(this.cfg.getString(name, "format"));
    }

    public boolean isSimple(String name) {
        for (String pkg : ChronicleLogConfig.PACKAGE_MASK) {
            if (!name.startsWith(pkg)) continue;
            return true;
        }
        return false;
    }

    public ChronicleLogWriter createWriter(String name) throws Exception {
        if (this.cfg == null) {
            throw new IllegalArgumentException("ChronicleLogManager is not configured");
        }
        String path = this.cfg.getString(name, "path");
        if (path != null) {
            ChronicleLogWriter appender = this.writers.get(path);
            if (appender == null) {
                Integer stDepth = this.cfg.getInteger("stackTraceDepth");
                String type = this.cfg.getString(name, "type");
                if (!this.isSimple(name)) {
                    if (this.isBinary(name)) {
                        appender = new ChronicleLogWriters.BinaryWriter(this.newChronicle(type, path, name));
                    } else if (this.isText(name)) {
                        appender = new ChronicleLogWriters.TextWriter(this.newChronicle(type, path, name), "yyyy.MM.dd-HH:mm:ss.SSS", stDepth);
                    }
                } else {
                    appender = new ChronicleLogWriters.SimpleWriter(System.out);
                }
                if (appender.getChronicle() instanceof IndexedChronicle) {
                    appender = new ChronicleLogWriters.SynchronizedWriter(appender);
                }
                this.writers.put(path, appender);
            }
            return appender;
        }
        throw new IllegalArgumentException("chronicle.logger.root.path is not defined" + "," + "chronicle.logger." + name + ".path is not defined");
    }

    private Chronicle newChronicle(String type, String path, String name) throws Exception {
        if ("indexed".equalsIgnoreCase(type)) {
            return this.newIndexedChronicle(path, name);
        }
        if ("vanilla".equalsIgnoreCase(type)) {
            return this.newVanillaChronicle(path, name);
        }
        throw new IllegalArgumentException("type should be indexed or vanilla");
    }

    private Chronicle newVanillaChronicle(String path, String name) throws IOException {
        Chronicle chronicle = this.cfg.getVanillaChronicleConfig().build(path);
        if (!this.cfg.getBoolean(name, "append", true).booleanValue()) {
            chronicle.clear();
        }
        return chronicle;
    }

    private Chronicle newIndexedChronicle(String path, String name) throws IOException {
        if (!this.cfg.getBoolean(name, "append", true).booleanValue()) {
            new File(path + ".data").delete();
            new File(path + ".index").delete();
        }
        return this.cfg.getIndexedChronicleConfig().build(path);
    }

    public static ChronicleLogManager getInstance() {
        return Holder.INSTANCE;
    }

    private static class Holder {
        private static final ChronicleLogManager INSTANCE = new ChronicleLogManager();

        private Holder() {
        }
    }
}

