/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import net.openhft.chronicle.logger.ChronicleLogEvent;
import net.openhft.chronicle.logger.ChronicleLogLevel;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.StopCharTester;
import net.openhft.lang.model.constraints.NotNull;

final class TextChronicleLogEvent
implements ChronicleLogEvent {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy.MM.dd-HH:mm:ss.SSS");
    private static final StopCharTester PIPE_TESTER = new StopCharTester(){

        public boolean isStopChar(int ch) throws IllegalStateException {
            return ch == 124;
        }
    };
    private static final ThreadLocal<StringBuilder> sbCache = new ThreadLocal<StringBuilder>(){

        @Override
        protected StringBuilder initialValue() {
            return new StringBuilder();
        }
    };
    private final long timestamp;
    private final ChronicleLogLevel level;
    private final String threadName;
    private final String loggerName;
    private final String message;

    static TextChronicleLogEvent read(@NotNull Bytes in) throws IllegalStateException {
        StringBuilder sb = sbCache.get();
        sb.setLength(0);
        in.parseUTF(sb, PIPE_TESTER);
        long timestamp = 0L;
        try {
            timestamp = DATE_FORMAT.parse(sb.toString()).getTime();
        }
        catch (Exception e) {
            // empty catch block
        }
        in.parseUTF(sb, PIPE_TESTER);
        ChronicleLogLevel level = ChronicleLogLevel.fromStringLevel(sb);
        in.parseUTF(sb, PIPE_TESTER);
        String threadName = sb.toString();
        in.parseUTF(sb, PIPE_TESTER);
        String loggerName = sb.toString();
        String message = in.readLine();
        return new TextChronicleLogEvent(timestamp, level, threadName, loggerName, message);
    }

    private TextChronicleLogEvent(long timestamp, ChronicleLogLevel level, String threadName, String loggerName, String message) {
        this.timestamp = timestamp;
        this.level = level;
        this.threadName = threadName;
        this.loggerName = loggerName;
        this.message = message;
    }

    @Override
    public byte getVersion() {
        return 0;
    }

    @Override
    public long getTimeStamp() {
        return this.timestamp;
    }

    @Override
    public String getThreadName() {
        return this.threadName;
    }

    @Override
    public ChronicleLogLevel getLevel() {
        return this.level;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Object[] getArgumentArray() {
        return EMPTY_ARGS;
    }

    @Override
    public boolean hasArguments() {
        return false;
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }

    @Override
    public Throwable getThrowable() {
        return null;
    }
}

