/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.replication;

import java.io.Serializable;
import net.openhft.chronicle.hash.replication.RemoteNodeValidator;
import net.openhft.chronicle.hash.replication.TcpTransportAndNetworkConfig;
import net.openhft.chronicle.hash.replication.UdpTransportConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractReplication
implements Serializable {
    private final byte localIdentifier;
    @Nullable
    private final TcpTransportAndNetworkConfig tcpConfig;
    @Nullable
    private final UdpTransportConfig udpConfig;
    @Nullable
    private final RemoteNodeValidator remoteNodeValidator;
    private final boolean bootstrapOnlyLocalEntries;

    AbstractReplication(byte localIdentifier, Builder builder) {
        this.localIdentifier = localIdentifier;
        this.tcpConfig = builder.tcpConfig;
        this.udpConfig = builder.udpConfig;
        this.remoteNodeValidator = builder.remoteNodeValidator;
        this.bootstrapOnlyLocalEntries = builder.bootstrapOnlyLocalEntries;
    }

    public String toString() {
        return "localIdentifier=" + this.localIdentifier + ", tcpConfig=" + this.tcpConfig + ", udpConfig=" + this.udpConfig + ", remoteNodeValidator=" + this.remoteNodeValidator + ", bootstrapOnlyLocalEntries=" + this.bootstrapOnlyLocalEntries;
    }

    public byte identifier() {
        return this.localIdentifier;
    }

    @Nullable
    public TcpTransportAndNetworkConfig tcpTransportAndNetwork() {
        return this.tcpConfig;
    }

    @Nullable
    public UdpTransportConfig udpTransport() {
        return this.udpConfig;
    }

    @Nullable
    public RemoteNodeValidator remoteNodeValidator() {
        return this.remoteNodeValidator;
    }

    public boolean bootstrapOnlyLocalEntries() {
        return this.bootstrapOnlyLocalEntries;
    }

    public static abstract class Builder<R extends AbstractReplication, B extends Builder<R, B>> {
        private TcpTransportAndNetworkConfig tcpConfig = null;
        private UdpTransportConfig udpConfig = null;
        private RemoteNodeValidator remoteNodeValidator = null;
        private boolean bootstrapOnlyLocalEntries = false;

        Builder() {
        }

        @NotNull
        public B tcpTransportAndNetwork(@Nullable TcpTransportAndNetworkConfig tcpConfig) {
            this.tcpConfig = tcpConfig;
            return (B)this;
        }

        @NotNull
        public B udpTransport(@Nullable UdpTransportConfig udpConfig) {
            this.udpConfig = udpConfig;
            return (B)this;
        }

        @NotNull
        public B remoteNodeValidator(@Nullable RemoteNodeValidator remoteNodeValidator) {
            this.remoteNodeValidator = remoteNodeValidator;
            return (B)this;
        }

        @NotNull
        public B bootstrapOnlyLocalEntries(boolean bootstrapOnlyLocalEntries) {
            this.bootstrapOnlyLocalEntries = bootstrapOnlyLocalEntries;
            return (B)this;
        }

        @NotNull
        public abstract R createWithId(byte var1);

        void check(byte identifier) {
            if (identifier <= 0) {
                throw new IllegalArgumentException("Identifier must be positive, " + identifier + " given");
            }
        }

        public String toString() {
            return ", udpConfig=" + this.udpConfig + ", remoteNodeValidator=" + this.remoteNodeValidator;
        }
    }
}

