/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.connection;

import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.network.ConnectionStrategy;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.NetworkStatsListener;
import net.openhft.chronicle.network.connection.FatalFailureMonitor;
import net.openhft.chronicle.network.connection.SocketAddressSupplier;
import net.openhft.chronicle.network.connection.TcpChannelHub;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FatalFailureConnectionStrategy
implements ConnectionStrategy {
    private static final long PAUSE = TimeUnit.MILLISECONDS.toNanos(300L);
    private final int attempts;
    private int tcpBufferSize = Integer.getInteger("tcp.client.buffer.size", TcpChannelHub.TCP_BUFFER);
    private boolean hasSentFatalFailure;

    public FatalFailureConnectionStrategy(int attempts) {
        this.attempts = attempts;
    }

    @Override
    @Nullable
    public SocketChannel connect(@NotNull String name, @NotNull SocketAddressSupplier socketAddressSupplier, @Nullable NetworkStatsListener<? extends NetworkContext> networkStatsListener, boolean didLogIn, @Nullable FatalFailureMonitor fatalFailureMonitor) throws InterruptedException {
        if (socketAddressSupplier.size() == 0 && !this.hasSentFatalFailure && fatalFailureMonitor != null) {
            this.hasSentFatalFailure = true;
            fatalFailureMonitor.onFatalFailure(name, "no connections have not been configured");
            LockSupport.parkNanos(PAUSE);
            return null;
        }
        int failures = 0;
        int maxFailures = socketAddressSupplier.size() * this.attempts;
        socketAddressSupplier.resetToPrimary();
        while (true) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            if (failures == maxFailures && fatalFailureMonitor != null) {
                if (!this.hasSentFatalFailure) {
                    this.hasSentFatalFailure = true;
                    fatalFailureMonitor.onFatalFailure(name, name);
                }
                return null;
            }
            SocketChannel socketChannel = null;
            try {
                InetSocketAddress socketAddress = socketAddressSupplier.get();
                if (socketAddress == null) {
                    ++failures;
                    socketAddressSupplier.failoverToNextAddress();
                    LockSupport.parkNanos(PAUSE);
                    continue;
                }
                long millis = TimeUnit.NANOSECONDS.toMillis(PAUSE);
                socketChannel = this.openSocketChannel(socketAddress, this.tcpBufferSize, millis);
                if (socketChannel == null) {
                    Jvm.warn().on(this.getClass(), "unable to connected to " + socketAddressSupplier.toString() + ", name=" + name);
                    ++failures;
                    socketAddressSupplier.failoverToNextAddress();
                    LockSupport.parkNanos(PAUSE);
                    continue;
                }
                if (Jvm.isDebugEnabled(this.getClass())) {
                    Jvm.debug().on(this.getClass(), "successfully connected to " + socketAddressSupplier);
                }
                if (networkStatsListener != null) {
                    networkStatsListener.onHostPort(socketAddress.getHostString(), socketAddress.getPort());
                }
                this.hasSentFatalFailure = false;
                failures = 0;
                return socketChannel;
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Throwable e) {
                if (socketChannel != null) {
                    Closeable.closeQuietly(socketChannel);
                }
                ++failures;
                socketAddressSupplier.failoverToNextAddress();
                LockSupport.parkNanos(PAUSE);
                continue;
            }
            break;
        }
    }
}

