/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.NetworkStatsListener;
import net.openhft.chronicle.network.connection.SocketAddressSupplier;
import net.openhft.chronicle.wire.Marshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ConnectionStrategy
extends Marshallable {
    public SocketChannel connect(String var1, SocketAddressSupplier var2, NetworkStatsListener<? extends NetworkContext> var3, boolean var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    default public SocketChannel openSocketChannel(@NotNull InetSocketAddress socketAddress, int tcpBufferSize) throws IOException {
        SocketChannel socketChannel;
        boolean failed;
        Selector selector;
        SocketChannel result;
        block14: {
            SocketChannel socketChannel2;
            block13: {
                SocketChannel socketChannel3;
                block12: {
                    result = SocketChannel.open();
                    selector = null;
                    failed = true;
                    try {
                        result.configureBlocking(false);
                        Socket socket = result.socket();
                        socket.setTcpNoDelay(true);
                        socket.setReceiveBufferSize(tcpBufferSize);
                        socket.setSendBufferSize(tcpBufferSize);
                        socket.setSoTimeout(0);
                        socket.setSoLinger(false, 0);
                        result.connect(socketAddress);
                        selector = Selector.open();
                        result.register(selector, 8);
                        int select = selector.select(2500L);
                        if (select == 0) {
                            Jvm.warn().on(this.getClass(), "Timed out attempting to connect to " + socketAddress);
                            socketChannel3 = null;
                            Closeable.closeQuietly((Object)selector);
                            if (!failed) return socketChannel3;
                            break block12;
                        }
                        if (!result.finishConnect()) {
                            socketChannel2 = null;
                            Closeable.closeQuietly((Object)selector);
                            break block13;
                        }
                        failed = false;
                        socketChannel = result;
                        Closeable.closeQuietly((Object)selector);
                        break block14;
                    }
                    catch (Exception e) {
                        SocketChannel socketChannel4 = null;
                        return socketChannel4;
                    }
                }
                Closeable.closeQuietly((Object)result);
                return socketChannel3;
            }
            if (!failed) return socketChannel2;
            Closeable.closeQuietly((Object)result);
            return socketChannel2;
        }
        if (!failed) return socketChannel;
        Closeable.closeQuietly((Object)result);
        return socketChannel;
        finally {
            Closeable.closeQuietly(selector);
            if (failed) {
                Closeable.closeQuietly((Object)result);
            }
        }
    }
}

