/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.text.ParseException;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.openhft.chronicle.queue.RollDetails;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.impl.CommonStore;
import net.openhft.chronicle.queue.impl.StoreFileListener;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.queue.impl.WireStoreSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WireStorePool {
    private static final Logger LOGGER = LoggerFactory.getLogger(WireStorePool.class);
    private static final int ROLL_CYCLE_CACHE_SIZE = 64;
    private static final int INDEX_MASK = 63;
    @NotNull
    private final WireStoreSupplier supplier;
    @NotNull
    private final Map<RollDetails, WeakReference<WireStore>> stores;
    private final StoreFileListener storeFileListener;
    private boolean isClosed = false;
    private final RollDetails[] cache = new RollDetails[64];

    private WireStorePool(@NotNull WireStoreSupplier supplier, StoreFileListener storeFileListener) {
        this.supplier = supplier;
        this.storeFileListener = storeFileListener;
        this.stores = new ConcurrentHashMap<RollDetails, WeakReference<WireStore>>();
    }

    @NotNull
    public static WireStorePool withSupplier(@NotNull WireStoreSupplier supplier, StoreFileListener storeFileListener) {
        return new WireStorePool(supplier, storeFileListener);
    }

    public synchronized void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.stores.values().stream().map(Reference::get).filter(Objects::nonNull).forEach(this::release);
    }

    @Nullable
    @net.openhft.chronicle.core.annotation.Nullable
    public synchronized WireStore acquire(int cycle, long epoch, boolean createIfAbsent) {
        WireStore store;
        WeakReference<WireStore> reference;
        int cacheIndex = WireStorePool.cacheIndex(cycle);
        RollDetails rollDetails = this.cache[cacheIndex];
        if (rollDetails == null || rollDetails.cycle() != cycle) {
            this.cache[cacheIndex] = rollDetails = new RollDetails(cycle, epoch);
        }
        if ((reference = this.stores.get((Object)rollDetails)) != null && (store = (WireStore)reference.get()) != null) {
            if (store.tryReserve()) {
                return store;
            }
            this.stores.remove((Object)rollDetails);
        }
        if ((store = this.supplier.acquire(cycle, createIfAbsent)) != null) {
            this.stores.put(rollDetails, new WeakReference<WireStore>(store));
            this.storeFileListener.onAcquired(cycle, store.file());
        }
        return store;
    }

    public int nextCycle(int currentCycle, @NotNull TailerDirection direction) throws ParseException {
        return this.supplier.nextCycle(currentCycle, direction);
    }

    public synchronized void release(@NotNull CommonStore store) {
        store.release();
        long refCount = store.refCount();
        assert (refCount >= 0L);
        if (refCount == 0L) {
            for (Map.Entry<RollDetails, WeakReference<WireStore>> entry : this.stores.entrySet()) {
                WeakReference<WireStore> ref = entry.getValue();
                if (ref == null || ref.get() != store) continue;
                this.stores.remove((Object)entry.getKey());
                this.storeFileListener.onReleased(entry.getKey().cycle(), store.file());
                return;
            }
            LOGGER.warn("Store was not registered {}", (Object)store.file().getName());
        }
    }

    public NavigableSet<Long> listCyclesBetween(int lowerCycle, int upperCycle) throws ParseException {
        return this.supplier.cycles(lowerCycle, upperCycle);
    }

    public boolean isEmpty() {
        return this.stores.isEmpty();
    }

    private static int cacheIndex(int cycle) {
        return cycle & 0x3F;
    }
}

