/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.salt;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.annotation.NotNull;
import net.openhft.chronicle.core.annotation.Nullable;
import net.openhft.chronicle.salt.Bridge;
import net.openhft.chronicle.salt.Sodium;

public enum EasyBox {


    public static BytesStore encrypt(BytesStore message, Nonce nonce, PublicKey publicKey, SecretKey secretKey) {
        return EasyBox.encrypt(null, message, nonce, publicKey, secretKey);
    }

    public static BytesStore encrypt(BytesStore result, BytesStore message, Nonce nonce, PublicKey publicKey, SecretKey secretKey) {
        return EasyBox.encrypt(result, message, nonce.store, publicKey.store, secretKey.store);
    }

    public static BytesStore encrypt(BytesStore result, BytesStore message, BytesStore nonce, BytesStore publicKey, BytesStore secretKey) {
        if (publicKey == null) {
            throw new RuntimeException("Encryption failed. Public key not available.");
        }
        if (secretKey == null) {
            throw new RuntimeException("Encryption failed. Private key not available.");
        }
        long length = message.readRemaining();
        long resultLength = length + 16L;
        result = Sodium.Util.setSize(result, resultLength);
        Sodium.checkValid(Bridge.crypto_box_easy(result.addressForWrite(0L), message.addressForRead(message.readPosition()), length, nonce.addressForRead(nonce.readPosition()), publicKey.addressForRead(publicKey.readPosition()), secretKey.addressForRead(secretKey.readPosition())), "Encryption failed");
        return result;
    }

    public static BytesStore encryptShared(BytesStore message, Nonce nonce, SharedKey sharedKey) {
        return EasyBox.encryptShared(null, message, nonce, sharedKey);
    }

    public static BytesStore encryptShared(BytesStore result, BytesStore message, Nonce nonce, SharedKey sharedKey) {
        return EasyBox.encryptShared(result, message, nonce.store, sharedKey.store);
    }

    public static BytesStore encryptShared(BytesStore result, BytesStore message, BytesStore nonce, BytesStore sharedKey) {
        if (sharedKey == null) {
            throw new RuntimeException("Encryption failed. Shared key not available.");
        }
        long length = message.readRemaining();
        long resultLength = length + 16L;
        result = Sodium.Util.setSize(result, resultLength);
        Sodium.checkValid(Sodium.SODIUM.crypto_box_easy_afternm(result.addressForWrite(0L), message.addressForRead(message.readPosition()), length, nonce.addressForRead(nonce.readPosition()), sharedKey.addressForRead(sharedKey.readPosition())), "Encryption failed");
        return result;
    }

    @NotNull
    public static BytesStore decrypt(@NotNull BytesStore ciphertext, Nonce nonce, PublicKey publicKey, SecretKey secretKey) {
        return EasyBox.decrypt(null, ciphertext, nonce, publicKey, secretKey);
    }

    public static BytesStore decrypt(@Nullable BytesStore result, @NotNull BytesStore ciphertext, Nonce nonce, PublicKey publicKey, SecretKey secretKey) {
        return EasyBox.decrypt(result, ciphertext, nonce.store, publicKey.store, secretKey.store);
    }

    public static BytesStore decrypt(@Nullable BytesStore result, @NotNull BytesStore ciphertext, BytesStore nonce, BytesStore publicKey, BytesStore secretKey) {
        if (publicKey == null) {
            throw new RuntimeException("Decryption failed. Public key not available.");
        }
        if (secretKey == null) {
            throw new RuntimeException("Decryption failed. Private key not available.");
        }
        long length = ciphertext.readRemaining();
        long resultLength = length - 16L;
        result = Sodium.Util.setSize(result, resultLength);
        Sodium.checkValid(Bridge.crypto_box_open_easy(result.addressForWrite(0L), ciphertext.addressForRead(ciphertext.readPosition()), length, nonce.addressForRead(nonce.readPosition()), publicKey.addressForRead(publicKey.readPosition()), secretKey.addressForRead(secretKey.readPosition())), "Decryption failed. Ciphertext failed verification");
        return result;
    }

    public static BytesStore decryptShared(@NotNull BytesStore ciphertext, Nonce nonce, SharedKey sharedKey) {
        return EasyBox.decryptShared(null, ciphertext, nonce, sharedKey);
    }

    public static BytesStore decryptShared(@Nullable BytesStore result, @NotNull BytesStore ciphertext, Nonce nonce, SharedKey sharedKey) {
        return EasyBox.decryptShared(result, ciphertext, nonce.store, sharedKey.store);
    }

    public static BytesStore decryptShared(@Nullable BytesStore result, @NotNull BytesStore ciphertext, BytesStore nonce, BytesStore sharedKey) {
        if (sharedKey == null) {
            throw new RuntimeException("Decryption failed. Shared key not available.");
        }
        long length = ciphertext.readRemaining();
        long resultLength = length - 16L;
        result = Sodium.Util.setSize(result, resultLength);
        Sodium.checkValid(Sodium.SODIUM.crypto_box_open_easy_afternm(result.addressForWrite(0L), ciphertext.addressForRead(ciphertext.readPosition()), length, nonce.addressForRead(nonce.readPosition()), sharedKey.addressForRead(sharedKey.readPosition())), "Decryption failed. Ciphertext failed verification");
        return result;
    }

    public static class KeyPair {
        public final PublicKey publicKey;
        public final SecretKey secretKey = new SecretKey();

        private KeyPair() {
            this.publicKey = new PublicKey();
            Sodium.SODIUM.crypto_box_keypair(this.publicKey.address(), this.secretKey.address());
        }

        private KeyPair(BytesStore seed) {
            this.publicKey = new PublicKey();
            seed = Sodium.Util.setSize(seed, 32L);
            Sodium.SODIUM.crypto_box_seed_keypair(this.publicKey.address(), this.secretKey.address(), seed.addressForWrite(0L));
        }

        public static KeyPair generate() {
            return new KeyPair();
        }

        public static KeyPair deterministic(long id) {
            VanillaBytes seed = Bytes.allocateDirect((long)32L);
            seed.writeLong(0L, id);
            return KeyPair.deterministic((BytesStore)seed);
        }

        public static KeyPair deterministic(BytesStore seed) {
            return new KeyPair(seed);
        }

        public void wipe() {
            this.secretKey.wipe();
        }
    }

    public static class SharedKey {
        public final BytesStore store = Bytes.allocateDirect((long)32L);

        private SharedKey() {
            ((Bytes)this.store).readLimit(32L);
        }

        public static SharedKey precalc(PublicKey publicKey, SecretKey secretKey) {
            SharedKey shared = new SharedKey();
            Sodium.SODIUM.crypto_box_beforenm(shared.address(), publicKey.address(), secretKey.address());
            return shared;
        }

        public static SharedKey precalc(KeyPair alice, KeyPair bob) {
            return SharedKey.precalc(alice.publicKey, bob.secretKey);
        }

        public long address() {
            return this.store.addressForRead(0L);
        }

        public void wipe() {
            Sodium.SODIUM.sodium_memzero(this.address(), 32L);
        }
    }

    public static class SecretKey {
        public final BytesStore store = Bytes.allocateDirect((long)32L);

        private SecretKey() {
            ((Bytes)this.store).readLimit(32L);
        }

        public long address() {
            return this.store.addressForRead(0L);
        }

        public void wipe() {
            Sodium.SODIUM.sodium_memzero(this.address(), 32L);
        }
    }

    public static class PublicKey {
        public final BytesStore store = Bytes.allocateDirect((long)32L);

        private PublicKey() {
            ((Bytes)this.store).readLimit(32L);
        }

        public long address() {
            return this.store.addressForRead(0L);
        }
    }

    public static class Nonce {
        public final BytesStore store;

        private Nonce(BytesStore store) {
            this.store = Sodium.Util.setSize(store, 24L);
            Sodium.SODIUM.randombytes_buf(this.store.addressForWrite(0L), 24);
        }

        private Nonce(BytesStore store, long id) {
            VanillaBytes seed = Bytes.allocateDirect((long)32L);
            seed.writeLong(0L, id);
            this.store = Sodium.Util.setSize(store, 24L);
            Sodium.SODIUM.randombytes_buf_deterministic(this.store.addressForWrite(0L), 24, seed.addressForWrite(0L));
        }

        private Nonce(BytesStore store, BytesStore seed) {
            seed = Sodium.Util.setSize(seed, 32L);
            this.store = Sodium.Util.setSize(store, 24L);
            Sodium.SODIUM.randombytes_buf_deterministic(this.store.addressForWrite(0L), 24, seed.addressForWrite(0L));
        }

        public static Nonce generate() {
            return Nonce.generate(null);
        }

        public static Nonce generate(BytesStore store) {
            return new Nonce(store);
        }

        public static Nonce deterministic(long id) {
            return Nonce.deterministic(null, id);
        }

        public static Nonce deterministic(BytesStore store, long id) {
            return new Nonce(store, id);
        }

        public static Nonce deterministic(BytesStore seed) {
            return Nonce.deterministic(null, seed);
        }

        public static Nonce deterministic(BytesStore store, BytesStore seed) {
            return new Nonce(store, seed);
        }

        public void next() {
            Sodium.SODIUM.sodium_increment(this.store.addressForWrite(0L), 24);
        }

        public void stir() {
            Sodium.SODIUM.randombytes_buf(this.store.addressForWrite(0L), 24);
        }

        public long address() {
            return this.store.addressForRead(0L);
        }
    }
}

