/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.Externalizable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.ReadResolvable;
import net.openhft.chronicle.wire.BracketType;
import net.openhft.chronicle.wire.Demarshallable;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.SerializationStrategy;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.Wires;

public enum SerializationStrategies implements SerializationStrategy
{
    MARSHALLABLE{

        public Object readUsing(Object o, ValueIn in) {
            ((ReadMarshallable)o).readMarshallable(in.wireIn());
            return o;
        }

        public Class type() {
            return Marshallable.class;
        }
    }
    ,
    ANY_OBJECT{

        public Object readUsing(Object o, ValueIn in) {
            return in.objectWithInferredType(o, ANY_NESTED, null);
        }

        public Class type() {
            return Object.class;
        }

        @Override
        public BracketType bracketType() {
            return BracketType.UNKNOWN;
        }
    }
    ,
    ANY_SCALAR{

        public Object readUsing(Object o, ValueIn in) {
            return in.objectWithInferredType(o, ANY_NESTED, null);
        }

        public Class type() {
            return Object.class;
        }

        @Override
        public BracketType bracketType() {
            return BracketType.NONE;
        }
    }
    ,
    ENUM{

        public Object readUsing(Object o, ValueIn in) {
            return in.objectWithInferredType(o, ANY_NESTED, null);
        }

        public Class type() {
            return Enum.class;
        }

        @Override
        public BracketType bracketType() {
            return BracketType.NONE;
        }
    }
    ,
    ANY_NESTED{

        public Object readUsing(Object o, ValueIn in) {
            Wires.readMarshallable(o, in.wireIn(), true);
            return o;
        }

        public Class type() {
            return Object.class;
        }
    }
    ,
    DEMARSHALLABLE{

        public Object readUsing(Object using, ValueIn in) {
            DemarshallableWrapper wrapper = (DemarshallableWrapper)using;
            wrapper.demarshallable = Demarshallable.newInstance(wrapper.type, in.wireIn());
            return wrapper;
        }

        public Class type() {
            return Demarshallable.class;
        }

        @Override
        public Object newInstance(Class type) {
            return new DemarshallableWrapper(type);
        }
    }
    ,
    SERIALIZABLE{

        public Object readUsing(Object o, ValueIn in) {
            if (o instanceof Externalizable) {
                EXTERNALIZABLE.readUsing(o, in);
            } else {
                ANY_OBJECT.readUsing(o, in);
            }
            return o;
        }

        public Class type() {
            return Serializable.class;
        }
    }
    ,
    EXTERNALIZABLE{

        public Object readUsing(Object o, ValueIn in) {
            try {
                ((Externalizable)o).readExternal(in.wireIn().objectInput());
            }
            catch (IOException | ClassNotFoundException e) {
                throw new IORuntimeException((Throwable)e);
            }
            return o;
        }

        public Class type() {
            return Externalizable.class;
        }

        @Override
        public BracketType bracketType() {
            return BracketType.SEQ;
        }
    }
    ,
    MAP{

        public Object readUsing(Object o, ValueIn in) {
            Map map = (Map)o;
            WireIn wireIn = in.wireIn();
            long pos = wireIn.bytes().readPosition();
            while (in.hasNext()) {
                Object key = wireIn.readEvent(Object.class);
                map.put(key, in.object());
                long pos2 = wireIn.bytes().readPosition();
                if (pos2 <= pos && !Jvm.isDebug()) {
                    throw new IllegalStateException(wireIn.bytes().toDebugString());
                }
                pos = pos2;
            }
            return o;
        }

        @Override
        public Object newInstance(Class type) {
            return new LinkedHashMap();
        }

        public Class type() {
            return Map.class;
        }
    }
    ,
    SET{

        public Object readUsing(Object o, ValueIn in) {
            Set set = (Set)o;
            WireIn wireIn = in.wireIn();
            Bytes<?> bytes = wireIn.bytes();
            long pos = bytes.readPosition();
            while (in.hasNextSequenceItem()) {
                Object object = in.object();
                set.add(object);
                long pos2 = bytes.readPosition();
                if (pos2 <= pos && !Jvm.isDebug()) {
                    throw new IllegalStateException(bytes.toDebugString());
                }
                pos = pos2;
            }
            return o;
        }

        @Override
        public Object newInstance(Class type) {
            return new LinkedHashSet();
        }

        public Class type() {
            return Set.class;
        }

        @Override
        public BracketType bracketType() {
            return BracketType.SEQ;
        }
    }
    ,
    LIST{

        public Object readUsing(Object o, ValueIn in) {
            List list = (List)o;
            WireIn wireIn = in.wireIn();
            long pos = wireIn.bytes().readPosition();
            while (in.hasNextSequenceItem()) {
                list.add(in.object());
                long pos2 = wireIn.bytes().readPosition();
                if (pos2 <= pos && !Jvm.isDebug()) {
                    throw new IllegalStateException(wireIn.bytes().toDebugString());
                }
                pos = pos2;
            }
            return o;
        }

        @Override
        public Object newInstance(Class type) {
            return new ArrayList();
        }

        public Class type() {
            return List.class;
        }

        @Override
        public BracketType bracketType() {
            return BracketType.SEQ;
        }
    }
    ,
    ARRAY{

        public Object readUsing(Object using, ValueIn in) {
            ArrayWrapper wrapper = (ArrayWrapper)using;
            Class<?> componentType = wrapper.type.getComponentType();
            ArrayList list = new ArrayList();
            while (in.hasNextSequenceItem()) {
                list.add(in.object(componentType));
            }
            wrapper.array = list.toArray((Object[])Array.newInstance(componentType, list.size()));
            return wrapper;
        }

        public Class type() {
            return Object[].class;
        }

        @Override
        public Object newInstance(Class type) {
            return new ArrayWrapper(type);
        }

        @Override
        public BracketType bracketType() {
            return BracketType.SEQ;
        }
    };


    public Object newInstance(Class type) {
        return ObjectUtils.newInstance((Class)type);
    }

    @Override
    public BracketType bracketType() {
        return BracketType.MAP;
    }

    static class DemarshallableWrapper
    implements ReadResolvable<Demarshallable> {
        final Class type;
        Demarshallable demarshallable;

        DemarshallableWrapper(Class type) {
            this.type = type;
        }

        public Demarshallable readResolve() {
            return this.demarshallable;
        }
    }

    static class ArrayWrapper
    implements ReadResolvable<Object[]> {
        final Class type;
        Object[] array;

        ArrayWrapper(Class type) {
            this.type = type;
        }

        public Object[] readResolve() {
            return this.array;
        }
    }
}

