/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle;

import java.io.IOException;
import net.openhft.chronicle.Chronicle;
import net.openhft.chronicle.Excerpt;
import net.openhft.chronicle.ExcerptCommon;
import net.openhft.chronicle.ExcerptComparator;
import net.openhft.chronicle.IndexedChronicle;
import net.openhft.lang.io.MappedMemory;
import net.openhft.lang.io.NativeBytes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractNativeExcerpt
extends NativeBytes
implements ExcerptCommon {
    @NotNull
    protected final IndexedChronicle chronicle;
    final int cacheLineMask;
    final int dataBlockSize;
    final int indexBlockSize;
    final int indexEntriesPerLine;
    final int indexEntriesPerBlock;
    private final int cacheLineSize;
    @Nullable
    MappedMemory indexBuffer;
    @Nullable
    MappedMemory dataBuffer;
    long index = -1L;
    long indexStartAddr;
    long indexStartOffset;
    long indexBaseForLine;
    long dataStartAddr;
    long dataStartOffset;
    long indexPositionAddr;
    boolean padding = true;

    public AbstractNativeExcerpt(@NotNull IndexedChronicle chronicle) throws IOException {
        super(0L, 0L, 0L);
        this.chronicle = chronicle;
        this.cacheLineSize = chronicle.config.cacheLineSize();
        this.cacheLineMask = this.cacheLineSize - 1;
        this.dataBlockSize = chronicle.config.dataBlockSize();
        this.indexBlockSize = chronicle.config.indexBlockSize();
        this.indexEntriesPerLine = (this.cacheLineSize - 8) / 4;
        this.indexEntriesPerBlock = this.indexBlockSize * this.indexEntriesPerLine / this.cacheLineSize;
        this.loadIndexBuffer();
        this.loadDataBuffer();
        this.finished = true;
    }

    @Override
    public long index() {
        return this.index;
    }

    public ExcerptCommon toStart() {
        this.index = -1L;
        return this;
    }

    protected boolean indexForRead(long l) throws IOException {
        if (l < 0L) {
            this.setIndexBuffer(0L, true);
            this.index = -1L;
            this.padding = true;
            return false;
        }
        long indexLookup = l / (long)this.indexEntriesPerBlock;
        this.setIndexBuffer(indexLookup, true);
        long indexLookupMod = l % (long)this.indexEntriesPerBlock;
        int indexLineEntry = (int)(indexLookupMod % (long)this.indexEntriesPerLine);
        int indexLineStart = (int)(indexLookupMod / (long)this.indexEntriesPerLine * (long)this.cacheLineSize);
        int inLine = (indexLineEntry << 2) + 8;
        int dataOffsetEnd = UNSAFE.getInt(this.indexStartAddr + (long)indexLineStart + (long)inLine);
        this.indexBaseForLine = UNSAFE.getLong(this.indexStartAddr + (long)indexLineStart);
        this.indexPositionAddr = this.indexStartAddr + (long)indexLineStart + (long)inLine;
        long dataOffsetStart = inLine == 0 ? this.indexBaseForLine : this.indexBaseForLine + (long)Math.abs(UNSAFE.getInt(this.indexPositionAddr - 4L));
        long dataLookup = dataOffsetStart / (long)this.dataBlockSize;
        long dataLookupMod = dataOffsetStart % (long)this.dataBlockSize;
        this.setDataBuffer(dataLookup);
        this.startAddr = this.positionAddr = this.dataStartAddr + dataLookupMod;
        this.index = l;
        if (dataOffsetEnd > 0) {
            this.limitAddr = this.dataStartAddr + (this.indexBaseForLine + (long)dataOffsetEnd - dataLookup * (long)this.dataBlockSize);
            this.indexPositionAddr += 4L;
            this.padding = false;
            return true;
        }
        if (dataOffsetEnd == 0) {
            this.limitAddr = this.startAddr;
            this.padding = false;
            return false;
        }
        this.padding = true;
        return false;
    }

    private void setIndexBuffer(long index, boolean prefetch) throws IOException {
        MappedMemory.release((MappedMemory)this.indexBuffer);
        this.indexBuffer = this.chronicle.indexFileCache.acquire(index, prefetch);
        this.indexPositionAddr = this.indexStartAddr = this.indexBuffer.address();
    }

    protected void indexForAppender(long l) throws IOException {
        if (l < 0L) {
            throw new IndexOutOfBoundsException("index: " + l);
        }
        if (l == 0L) {
            this.indexStartOffset = 0L;
            this.loadIndexBuffer();
            this.dataStartOffset = 0L;
            this.loadDataBuffer();
            return;
        }
        long indexLookup = --l / (long)this.indexEntriesPerBlock;
        this.setIndexBuffer(indexLookup, true);
        long indexLookupMod = l % (long)this.indexEntriesPerBlock;
        int indexLineEntry = (int)(indexLookupMod % (long)this.indexEntriesPerLine);
        int indexLineStart = (int)(indexLookupMod / (long)this.indexEntriesPerLine * (long)this.cacheLineSize);
        int inLine = (indexLineEntry << 2) + 8;
        this.indexStartOffset = indexLookup * (long)this.indexBlockSize + (long)indexLineStart;
        this.indexBaseForLine = UNSAFE.getLong(this.indexStartAddr + (long)indexLineStart);
        long dataOffsetEnd = this.indexBaseForLine + (long)Math.abs(UNSAFE.getInt(this.indexStartAddr + (long)indexLineStart + (long)inLine));
        long dataLookup = dataOffsetEnd / (long)this.dataBlockSize;
        long dataLookupMod = dataOffsetEnd % (long)this.dataBlockSize;
        this.setDataBuffer(dataLookup);
        this.dataStartOffset = dataLookup * (long)this.dataBlockSize;
        this.startAddr = this.positionAddr = this.dataStartAddr + dataLookupMod;
        this.index = l + 1L;
        this.indexPositionAddr = this.indexStartAddr + (long)indexLineStart + (long)inLine + 4L;
    }

    private void setDataBuffer(long dataLookup) throws IOException {
        MappedMemory.release((MappedMemory)this.dataBuffer);
        this.dataBuffer = this.chronicle.dataFileCache.acquire(dataLookup, true);
        this.dataStartAddr = this.dataBuffer.address();
    }

    @Override
    public boolean wasPadding() {
        return this.padding;
    }

    @Override
    public long lastWrittenIndex() {
        return this.chronicle.lastWrittenIndex();
    }

    @Override
    public long size() {
        return this.chronicle.size();
    }

    @Override
    @NotNull
    public Chronicle chronicle() {
        return this.chronicle;
    }

    void loadNextIndexBuffer() throws IOException {
        this.indexStartOffset += (long)this.indexBlockSize;
        this.loadIndexBuffer();
    }

    void loadNextDataBuffer() throws IOException {
        this.dataStartOffset += (long)this.dataBlockSize;
        this.loadDataBuffer();
    }

    void loadNextDataBuffer(long offsetInThisBuffer) throws IOException {
        this.dataStartOffset += offsetInThisBuffer / (long)this.dataBlockSize * (long)this.dataBlockSize;
        this.loadDataBuffer();
    }

    void loadDataBuffer() throws IOException {
        this.setDataBuffer(this.dataStartOffset / (long)this.dataBlockSize);
        this.positionAddr = this.limitAddr = this.dataStartAddr;
        this.startAddr = this.limitAddr;
    }

    void loadIndexBuffer() throws IOException {
        this.setIndexBuffer(this.indexStartOffset / (long)this.indexBlockSize, true);
    }

    public boolean index(long index) {
        throw new UnsupportedOperationException();
    }

    public long findMatch(@NotNull ExcerptComparator comparator) {
        long lo = 0L;
        long hi = this.lastWrittenIndex();
        while (lo <= hi) {
            long mid = hi + lo >>> 1;
            if (!this.index(mid)) {
                if (mid <= lo) break;
                this.index(--mid);
            }
            int cmp = comparator.compare((Excerpt)((Object)this));
            this.finish();
            if (cmp < 0) {
                lo = mid + 1L;
                continue;
            }
            if (cmp > 0) {
                hi = mid - 1L;
                continue;
            }
            return mid;
        }
        return lo ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public void findRange(@NotNull long[] startEnd, @NotNull ExcerptComparator comparator) {
        int cmp;
        long mid;
        long lo1 = 0L;
        long hi1 = this.lastWrittenIndex();
        long lo2 = 0L;
        long hi2 = hi1;
        boolean both = true;
        while (lo1 <= hi1) {
            mid = hi1 + lo1 >>> 1;
            if (!this.index(mid)) {
                if (mid <= lo1) break;
                this.index(--mid);
            }
            cmp = comparator.compare((Excerpt)((Object)this));
            this.finish();
            if (cmp < 0) {
                lo1 = mid + 1L;
                if (!both) continue;
                lo2 = lo1;
                continue;
            }
            if (cmp > 0) {
                hi1 = mid - 1L;
                if (!both) continue;
                hi2 = hi1;
                continue;
            }
            hi1 = mid - 1L;
            if (both) {
                lo2 = mid + 1L;
            }
            both = false;
        }
        while (lo2 <= hi2) {
            mid = hi2 + lo2 >>> 1;
            if (!this.index(mid)) {
                if (mid <= lo2) break;
                this.index(--mid);
            }
            cmp = comparator.compare((Excerpt)((Object)this));
            this.finish();
            if (cmp <= 0) {
                lo2 = mid + 1L;
                continue;
            }
            hi2 = mid - 1L;
        }
        startEnd[0] = lo1;
        startEnd[1] = lo2;
    }
}

