/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle;

import java.io.FileNotFoundException;
import java.io.IOException;
import net.openhft.chronicle.IndexedChronicle;

public class IndexedChronicleCache {
    private final String basePath;
    private IndexedChronicle chronicle;
    private int chronicleIndex = -1;

    public IndexedChronicleCache(String basePath) {
        this.basePath = basePath;
    }

    public IndexedChronicle acquireChronicle(int index) throws FileNotFoundException {
        if (index == this.chronicleIndex) {
            return this.chronicle;
        }
        this.chronicleIndex = index;
        String basePath2 = this.basePath + "/" + index;
        this.chronicle = new IndexedChronicle(basePath2);
        return this.chronicle;
    }

    public void close() throws IOException {
        if (this.chronicle != null) {
            this.chronicle.close();
        }
    }
}

