/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle;

import java.io.IOException;
import java.util.ConcurrentModificationException;
import net.openhft.chronicle.AbstractNativeExcerpt;
import net.openhft.chronicle.ExcerptAppender;
import net.openhft.chronicle.IndexedChronicle;
import org.jetbrains.annotations.NotNull;

public class NativeExcerptAppender
extends AbstractNativeExcerpt
implements ExcerptAppender {
    private boolean nextSynchronous;

    public NativeExcerptAppender(@NotNull IndexedChronicle chronicle) throws IOException {
        super(chronicle);
        this.toEnd();
    }

    @Override
    public void startExcerpt() {
        this.startExcerpt(this.chronicle.config().messageCapacity());
    }

    @Override
    public void startExcerpt(long capacity) {
        if (this.index != this.size()) {
            this.toEnd();
        }
        if (capacity >= (long)this.chronicle.config.dataBlockSize()) {
            throw new IllegalArgumentException("Capacity too large " + capacity + " >= " + this.chronicle.config.dataBlockSize());
        }
        if (this.positionAddr + capacity > this.dataStartAddr + (long)this.dataBlockSize) {
            this.checkNewIndexLine();
            this.writePaddedEntry();
            try {
                this.loadNextDataBuffer();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        this.checkNewIndexLine();
        this.startAddr = this.positionAddr;
        this.limitAddr = this.positionAddr + capacity;
        this.finished = false;
        this.nextSynchronous = this.chronicle.config.synchronousMode();
    }

    @Override
    public void nextSynchronous(boolean nextSynchronous) {
        this.nextSynchronous = nextSynchronous;
    }

    @Override
    public boolean nextSynchronous() {
        return this.nextSynchronous;
    }

    @Override
    public void addPaddedEntry() {
        if (this.index != this.lastWrittenIndex()) {
            this.toEnd();
        }
        this.checkNewIndexLine();
        this.writePaddedEntry();
        try {
            this.loadNextDataBuffer();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.checkNewIndexLine();
        this.finished = true;
    }

    private void writePaddedEntry() {
        int size = (int)((long)this.dataBlockSize + this.dataStartOffset - this.indexBaseForLine);
        assert (size >= 0);
        if (size == 0) {
            return;
        }
        this.appendIndexPaddingEntry(size);
        this.indexPositionAddr += 4L;
        ++this.index;
        this.chronicle.incrSize();
    }

    private void appendIndexPaddingEntry(int size) {
        assert (this.index < (long)this.indexEntriesPerLine || UNSAFE.getLong(this.indexPositionAddr & (long)(~this.cacheLineMask)) != 0L) : "index: " + this.index + ", no start of line set.";
        UNSAFE.putInt(this.indexPositionAddr, -size);
    }

    @Override
    public void finish() {
        super.finish();
        if (this.index != this.chronicle.size()) {
            throw new ConcurrentModificationException("Chronicle appended by more than one Appender at the same time, index=" + this.index + ", size=" + this.chronicle().size());
        }
        long offsetInBlock = this.positionAddr - this.dataStartAddr;
        assert (offsetInBlock >= 0L && offsetInBlock <= (long)this.dataBlockSize);
        int relativeOffset = (int)(this.dataStartOffset + offsetInBlock - this.indexBaseForLine);
        assert (relativeOffset > 0);
        this.writeIndexEntry(relativeOffset);
        this.indexPositionAddr += 4L;
        ++this.index;
        this.chronicle.incrSize();
        if ((this.indexPositionAddr & (long)this.cacheLineMask) == 0L && this.indexPositionAddr - this.indexStartAddr < (long)this.indexBlockSize) {
            this.indexBaseForLine += (long)relativeOffset;
            this.appendStartOfLine();
        }
        if (this.nextSynchronous) {
            assert (this.dataBuffer != null);
            this.dataBuffer.force();
            assert (this.indexBuffer != null);
            this.indexBuffer.force();
        }
    }

    private void writeIndexEntry(int relativeOffset) {
        UNSAFE.putOrderedInt(null, this.indexPositionAddr, relativeOffset);
    }

    @Override
    @NotNull
    public ExcerptAppender toEnd() {
        this.index = this.chronicle().size();
        try {
            this.indexForAppender(this.index);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    void checkNewIndexLine() {
        switch ((int)(this.indexPositionAddr & (long)this.cacheLineMask)) {
            case 0: {
                this.newIndexLine();
                break;
            }
            case 4: {
                throw new AssertionError();
            }
        }
    }

    void newIndexLine() {
        if (this.indexPositionAddr >= this.indexStartAddr + (long)this.indexBlockSize) {
            try {
                this.loadNextIndexBuffer();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        this.indexBaseForLine = this.positionAddr - this.dataStartAddr + this.dataStartOffset;
        assert ((this.index == 0L || this.indexBaseForLine > 0L) && this.indexBaseForLine < 0x1000000000000L) : "dataPositionAtStartOfLine out of bounds, was " + this.indexBaseForLine;
        this.appendStartOfLine();
    }

    private void appendStartOfLine() {
        UNSAFE.putLong(this.indexPositionAddr, this.indexBaseForLine);
        this.indexPositionAddr += 8L;
    }
}

