/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle;

import java.io.IOException;
import net.openhft.chronicle.AbstractNativeExcerpt;
import net.openhft.chronicle.ExcerptTailer;
import net.openhft.chronicle.IndexedChronicle;
import org.jetbrains.annotations.NotNull;

public class NativeExcerptTailer
extends AbstractNativeExcerpt
implements ExcerptTailer {
    public static final long UNSIGNED_INT_MASK = 0xFFFFFFFFL;

    public NativeExcerptTailer(@NotNull IndexedChronicle chronicle) throws IOException {
        super(chronicle);
    }

    @Override
    public boolean index(long l) {
        try {
            return this.indexForRead(l);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    @NotNull
    public ExcerptTailer toEnd() {
        this.index = this.chronicle().size();
        try {
            this.indexForRead(this.index);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    @Override
    @NotNull
    public ExcerptTailer toStart() {
        super.toStart();
        return this;
    }

    @Override
    public boolean nextIndex() {
        this.checkNextLine();
        long offset = UNSAFE.getInt(null, this.indexPositionAddr);
        if (offset == 0L) {
            offset = UNSAFE.getIntVolatile(null, this.indexPositionAddr);
        }
        if (offset == 0L) {
            return false;
        }
        ++this.index;
        return this.nextIndex0(offset) || this.nextIndex1();
    }

    private boolean nextIndex1() {
        this.checkNextLine();
        long offset = UNSAFE.getInt(null, this.indexPositionAddr);
        if (offset == 0L) {
            offset = UNSAFE.getIntVolatile(null, this.indexPositionAddr);
        }
        if (offset == 0L) {
            return false;
        }
        ++this.index;
        return this.nextIndex0(offset);
    }

    private void checkNextLine() {
        switch ((int)(this.indexPositionAddr & (long)this.cacheLineMask)) {
            case 0: {
                this.newIndexLine();
                this.indexPositionAddr += 8L;
                break;
            }
            case 4: {
                throw new AssertionError();
            }
        }
    }

    private void newIndexLine() {
        if (this.indexPositionAddr >= this.indexStartAddr + (long)this.indexBlockSize) {
            try {
                this.loadNextIndexBuffer();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private boolean nextIndex0(long offset) {
        boolean present = true;
        boolean bl = this.padding = offset < 0L;
        if (this.padding) {
            present = false;
            offset = -offset;
        }
        this.checkNewIndexLine2();
        this.startAddr = this.positionAddr = this.limitAddr;
        this.setLmitAddr(offset);
        assert (this.limitAddr >= this.startAddr || !present && this.limitAddr == this.startAddr);
        this.indexPositionAddr += 4L;
        return present;
    }

    private void setLmitAddr(long offset) {
        long offsetInThisBuffer = this.indexBaseForLine + offset - this.dataStartOffset;
        if (offsetInThisBuffer > (long)this.dataBlockSize) {
            try {
                this.loadNextDataBuffer(offsetInThisBuffer);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            offsetInThisBuffer = this.indexBaseForLine + offset - this.dataStartOffset;
        }
        assert (offsetInThisBuffer >= 0L && offsetInThisBuffer <= (long)this.dataBlockSize) : "index: " + this.index + ", offsetInThisBuffer: " + offsetInThisBuffer;
        this.limitAddr = this.dataStartAddr + offsetInThisBuffer;
    }

    void checkNewIndexLine2() {
        if ((this.indexPositionAddr & (long)this.cacheLineMask) == 8L) {
            this.indexBaseForLine = UNSAFE.getLongVolatile(null, this.indexPositionAddr - 8L);
            assert (this.index <= (long)this.indexEntriesPerLine || this.indexBaseForLine > 0L) : "index: " + this.index + " indexBaseForLine: " + this.indexBaseForLine;
            this.setLmitAddr(0L);
        }
    }
}

