/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.tcp;

import java.io.EOFException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.openhft.chronicle.Chronicle;
import net.openhft.chronicle.ChronicleConfig;
import net.openhft.chronicle.Excerpt;
import net.openhft.chronicle.ExcerptAppender;
import net.openhft.chronicle.ExcerptCommon;
import net.openhft.chronicle.ExcerptTailer;
import net.openhft.chronicle.IndexedChronicle;
import net.openhft.chronicle.tcp.TcpUtil;
import net.openhft.chronicle.tools.WrappedExcerpt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InProcessChronicleSink
implements Chronicle {
    @NotNull
    private final Chronicle chronicle;
    @NotNull
    private final SocketAddress address;
    private final ExcerptAppender excerpt;
    private final Logger logger;
    private volatile boolean closed = false;
    @Nullable
    private SocketChannel sc = null;
    private boolean scFirst = true;
    private final ByteBuffer readBuffer;

    public InProcessChronicleSink(@NotNull Chronicle chronicle, String hostname, int port) throws IOException {
        this.chronicle = chronicle;
        this.address = new InetSocketAddress(hostname, port);
        this.logger = Logger.getLogger(this.getClass().getName() + '.' + chronicle);
        this.excerpt = chronicle.createAppender();
        this.readBuffer = TcpUtil.createBuffer(262144, ByteOrder.nativeOrder());
    }

    @Override
    public String name() {
        return this.chronicle.name();
    }

    @Override
    @NotNull
    public Excerpt createExcerpt() throws IOException {
        return new SinkExcerpt(this.chronicle.createExcerpt());
    }

    @Override
    @NotNull
    public ExcerptTailer createTailer() throws IOException {
        return new SinkExcerpt(this.chronicle.createTailer());
    }

    @Override
    @NotNull
    public ExcerptAppender createAppender() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long lastWrittenIndex() {
        return this.chronicle.lastWrittenIndex();
    }

    @Override
    public long size() {
        return this.chronicle.size();
    }

    boolean readNext() {
        if (this.sc == null || !this.sc.isOpen()) {
            this.sc = this.createConnection();
            this.scFirst = true;
        }
        return this.sc != null && this.readNextExcerpt(this.sc);
    }

    @Nullable
    private SocketChannel createConnection() {
        while (!this.closed) {
            try {
                this.readBuffer.clear();
                this.readBuffer.limit(0);
                SocketChannel sc = SocketChannel.open(this.address);
                sc.socket().setReceiveBufferSize(262144);
                this.logger.info("Connected to " + this.address);
                ByteBuffer bb = ByteBuffer.allocate(8);
                bb.putLong(0, this.chronicle.lastWrittenIndex());
                TcpUtil.writeAllOrEOF(sc, bb);
                return sc;
            }
            catch (IOException e) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "Failed to connect to " + this.address + " retrying", e);
                } else if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "Failed to connect to " + this.address + " retrying " + e);
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    return null;
                }
            }
        }
        return null;
    }

    private boolean readNextExcerpt(@NotNull SocketChannel sc) {
        try {
            if (this.closed) {
                return false;
            }
            if (this.readBuffer.remaining() < (this.scFirst ? 12 : 4)) {
                int minSize;
                if (this.readBuffer.remaining() == 0) {
                    this.readBuffer.clear();
                } else {
                    this.readBuffer.compact();
                }
                int n = minSize = this.scFirst ? 20 : 12;
                while (this.readBuffer.position() < minSize) {
                    if (sc.read(this.readBuffer) >= 0) continue;
                    sc.close();
                    return false;
                }
                this.readBuffer.flip();
            }
            if (this.scFirst) {
                long scIndex = this.readBuffer.getLong();
                if (scIndex != this.chronicle.size()) {
                    throw new StreamCorruptedException("Expected index " + this.chronicle.size() + " but got " + scIndex);
                }
                this.scFirst = false;
            }
            int size = this.readBuffer.getInt();
            switch (size) {
                case -128: {
                    return false;
                }
                case -127: {
                    this.excerpt.startExcerpt(((IndexedChronicle)this.chronicle).config().dataBlockSize() - 1);
                    return true;
                }
            }
            if (size > 0x8000000 || size < 0) {
                throw new StreamCorruptedException("size was " + size);
            }
            this.excerpt.startExcerpt(size);
            long remaining = size;
            int limit = this.readBuffer.limit();
            int size2 = (int)Math.min((long)this.readBuffer.remaining(), remaining);
            remaining -= (long)size2;
            this.readBuffer.limit(this.readBuffer.position() + size2);
            this.excerpt.write(this.readBuffer);
            this.readBuffer.limit(limit);
            while (remaining > 0L) {
                this.readBuffer.clear();
                int size3 = (int)Math.min((long)this.readBuffer.capacity(), remaining);
                this.readBuffer.limit(size3);
                if (sc.read(this.readBuffer) < 0) {
                    throw new EOFException();
                }
                this.readBuffer.flip();
                remaining -= (long)this.readBuffer.remaining();
                this.excerpt.write(this.readBuffer);
            }
            this.excerpt.finish();
        }
        catch (IOException e) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Lost connection to " + this.address + " retrying", e);
            } else if (this.logger.isLoggable(Level.INFO)) {
                this.logger.log(Level.INFO, "Lost connection to " + this.address + " retrying " + e);
            }
            try {
                sc.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return true;
    }

    void closeSocket(@Nullable SocketChannel sc) {
        if (sc != null) {
            try {
                sc.close();
            }
            catch (IOException e) {
                this.logger.warning("Error closing socket " + e);
            }
        }
    }

    @Override
    public void close() {
        this.closed = true;
        this.closeSocket(this.sc);
    }

    public ChronicleConfig config() {
        return ((IndexedChronicle)this.chronicle).config();
    }

    private class SinkExcerpt
    extends WrappedExcerpt {
        public SinkExcerpt(ExcerptCommon excerpt) throws IOException {
            super(excerpt);
        }

        @Override
        public boolean nextIndex() {
            return super.nextIndex() || InProcessChronicleSink.this.readNext() && super.nextIndex();
        }

        @Override
        public boolean index(long index) throws IndexOutOfBoundsException {
            if (super.index(index)) {
                return true;
            }
            return index >= 0L && InProcessChronicleSink.this.readNext() && super.index(index);
        }
    }
}

