/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.tools;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public class ChronicleIndexReader {
    static final boolean HEX = Boolean.getBoolean("hex");

    public static void main(String ... args) throws IOException {
        FileChannel fc;
        int zeros = 0;
        try {
            fc = new FileInputStream(args[0]).getChannel();
        }
        catch (FileNotFoundException e) {
            System.err.println(e);
            return;
        }
        int count = 0;
        ByteBuffer buffer = ByteBuffer.allocateDirect(4096).order(ByteOrder.nativeOrder());
        while (fc.read(buffer) > 0) {
            for (int i = 0; i < buffer.capacity(); i += 64) {
                long indexStart = buffer.getLong(i);
                if (indexStart == 0L && zeros++ > 2) continue;
                System.out.print(count + ": ");
                count += 14;
                System.out.print(HEX ? Long.toHexString(indexStart) : String.valueOf(indexStart));
                for (int j = i + 8; j < i + 64; j += 4) {
                    System.out.print(' ');
                    int offset = buffer.getInt(j);
                    System.out.print(HEX ? Integer.toHexString(offset) : String.valueOf(offset));
                }
                System.out.println();
            }
            buffer.clear();
        }
        fc.close();
    }
}

