/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.tools;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public class DailingRollingReader {
    public static void main(String[] args) throws IOException {
        DailingRollingReader.dumpData(args[0], new PrintWriter(System.out));
    }

    public static void dumpData(String filename, Writer writer) throws IOException {
        PrintWriter pw = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        FileChannel fc = new FileInputStream(filename).getChannel();
        try {
            ByteBuffer bb = ByteBuffer.allocateDirect(4096).order(ByteOrder.nativeOrder());
            long index = 0L;
            int size = 0;
            block4: while (true) {
                bb.clear();
                fc.read(bb);
                bb.flip();
                while (true) {
                    if (bb.remaining() <= 0) continue block4;
                    while (bb.remaining() > 0 && size > 0) {
                        int b = bb.get();
                        if (b < 32 || b > 126) {
                            b = 46;
                        }
                        pw.print((char)b);
                        --size;
                    }
                    if (size != 0) continue;
                    while ((bb.position() & 3) != 0) {
                        bb.get();
                    }
                    if (bb.remaining() < 4) continue;
                    size = bb.getInt();
                    pw.println();
                    if (size == 0) {
                        pw.println("Exceprts " + index);
                        return;
                    }
                    pw.print(index++);
                    pw.print(":");
                    pw.print(size);
                    pw.print(":");
                }
                break;
            }
        }
        finally {
            fc.close();
        }
    }
}

