/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle;

import java.nio.ByteOrder;
import net.openhft.lang.Jvm;
import net.openhft.lang.model.constraints.NotNull;

public class ChronicleConfig
implements Cloneable {
    public static final ChronicleConfig SMALL = new ChronicleConfig(4096, 0x200000, true, 0x1000000);
    public static final ChronicleConfig MEDIUM = new ChronicleConfig(16384, 0x1000000, false, 0x8000000);
    public static final ChronicleConfig LARGE = new ChronicleConfig(65536, 0x4000000, false, 0x20000000);
    public static final ChronicleConfig HUGE = new ChronicleConfig(0x400000, 0x10000000, false, 0x20000000);
    public static final ChronicleConfig TEST = new ChronicleConfig(0x100000, 8192, true, 8192);
    public static final ChronicleConfig DEFAULT = Jvm.is64Bit() ? MEDIUM : SMALL;
    private int indexFileCapacity;
    private int indexFileExcerpts;
    private boolean minimiseFootprint;
    private boolean useUnsafe = false;
    private boolean synchronousMode = false;
    private ByteOrder byteOrder = ByteOrder.nativeOrder();
    private int cacheLineSize = 64;
    private int dataBlockSize;
    private int indexBlockSize;
    private int messageCapacity = 131072;
    private boolean useCheckedExcerpt = false;

    private ChronicleConfig(int indexFileCapacity, int indexFileExcerpts, boolean minimiseFootprint, int dataBlockSize) {
        this.indexFileCapacity = indexFileCapacity;
        this.indexFileExcerpts = indexFileExcerpts;
        this.minimiseFootprint = minimiseFootprint;
        this.dataBlockSize = dataBlockSize;
        this.indexBlockSize = Math.max(4096, this.dataBlockSize / 4);
    }

    public ChronicleConfig indexFileCapacity(int indexFileCapacity) {
        this.indexFileCapacity = indexFileCapacity;
        return this;
    }

    public int indexFileCapacity() {
        return this.indexFileCapacity;
    }

    public ChronicleConfig indexFileExcerpts(int indexFileExcerpts) {
        this.indexFileExcerpts = indexFileExcerpts;
        return this;
    }

    public int indexFileExcerpts() {
        return this.indexFileExcerpts;
    }

    public void minimiseFootprint(boolean minimiseFootprint) {
        this.minimiseFootprint = minimiseFootprint;
    }

    public boolean minimiseFootprint() {
        return this.minimiseFootprint;
    }

    public ChronicleConfig useUnsafe(boolean useUnsafe) {
        this.useUnsafe = useUnsafe;
        return this;
    }

    public boolean useUnsafe() {
        return this.useUnsafe;
    }

    public ChronicleConfig synchronousMode(boolean synchronousMode) {
        this.synchronousMode = synchronousMode;
        return this;
    }

    public boolean synchronousMode() {
        return this.synchronousMode;
    }

    public ChronicleConfig byteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
        return this;
    }

    public ByteOrder byteOrder() {
        return this.byteOrder;
    }

    public ChronicleConfig cacheLineSize(int cacheLineSize) {
        this.cacheLineSize = cacheLineSize;
        return this;
    }

    public int cacheLineSize() {
        return this.cacheLineSize;
    }

    public ChronicleConfig dataBlockSize(int dataBlockSize) {
        this.dataBlockSize = dataBlockSize;
        if (this.messageCapacity > dataBlockSize / 2) {
            this.messageCapacity = dataBlockSize / 2;
        }
        return this;
    }

    public int dataBlockSize() {
        return this.dataBlockSize;
    }

    public ChronicleConfig indexBlockSize(int indexBlockSize) {
        this.indexBlockSize = indexBlockSize;
        return this;
    }

    public int indexBlockSize() {
        return this.indexBlockSize;
    }

    public ChronicleConfig messageCapacity(int messageCapacity) {
        this.messageCapacity = messageCapacity;
        return this;
    }

    public int messageCapacity() {
        return this.messageCapacity;
    }

    public boolean useCheckedExcerpt() {
        return this.useCheckedExcerpt;
    }

    public void useCheckedExcerpt(boolean useCheckedExcerpt) {
        this.useCheckedExcerpt = useCheckedExcerpt;
    }

    @NotNull
    public ChronicleConfig clone() {
        try {
            return (ChronicleConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }
}

