/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import net.openhft.affinity.AffinitySupport;
import net.openhft.chronicle.Chronicle;
import net.openhft.chronicle.DateCache;
import net.openhft.chronicle.Excerpt;
import net.openhft.chronicle.ExcerptAppender;
import net.openhft.chronicle.ExcerptCommon;
import net.openhft.chronicle.ExcerptComparator;
import net.openhft.chronicle.ExcerptTailer;
import net.openhft.chronicle.VanillaChronicleConfig;
import net.openhft.chronicle.VanillaDataCache;
import net.openhft.chronicle.VanillaIndexCache;
import net.openhft.chronicle.tools.CheckedExcerpt;
import net.openhft.lang.Maths;
import net.openhft.lang.io.IOTools;
import net.openhft.lang.io.NativeBytes;
import net.openhft.lang.io.VanillaMappedBytes;
import net.openhft.lang.io.serialization.BytesMarshallerFactory;
import net.openhft.lang.io.serialization.impl.VanillaBytesMarshallerFactory;
import net.openhft.lang.model.constraints.NotNull;

public class VanillaChronicle
implements Chronicle {
    private final String name;
    private final String basePath;
    private final VanillaChronicleConfig config;
    private final ThreadLocal<WeakReference<BytesMarshallerFactory>> marshallersCache = new ThreadLocal();
    private final ThreadLocal<WeakReference<VanillaTailer>> tailerCache = new ThreadLocal();
    private final ThreadLocal<WeakReference<VanillaAppender>> appenderCache = new ThreadLocal();
    private final VanillaIndexCache indexCache;
    private final VanillaDataCache dataCache;
    private final int indexBlockLongsBits;
    private final int indexBlockLongsMask;
    private final int dataBlockSizeBits;
    private final int dataBlockSizeMask;
    private final int entriesForCycleBits;
    private final long entriesForCycleMask;
    private volatile long lastWrittenIndex;
    private volatile boolean closed = false;

    public VanillaChronicle(String basePath) {
        this(basePath, VanillaChronicleConfig.DEFAULT);
    }

    public VanillaChronicle(String basePath, VanillaChronicleConfig config) {
        this.basePath = basePath;
        this.config = config;
        this.name = new File(basePath).getName();
        DateCache dateCache = new DateCache(config.cycleFormat(), config.cycleLength());
        int indexBlockSizeBits = Maths.intLog2((long)config.indexBlockSize());
        int indexBlockSizeMask = -1 >>> -indexBlockSizeBits;
        this.indexCache = new VanillaIndexCache(basePath, indexBlockSizeBits, dateCache, config);
        this.indexBlockLongsBits = indexBlockSizeBits - 3;
        this.indexBlockLongsMask = indexBlockSizeMask >>> 3;
        this.dataBlockSizeBits = Maths.intLog2((long)config.dataBlockSize());
        this.dataBlockSizeMask = -1 >>> -this.dataBlockSizeBits;
        this.dataCache = new VanillaDataCache(basePath, this.dataBlockSizeBits, dateCache, config);
        this.entriesForCycleBits = Maths.intLog2((long)config.entriesPerCycle());
        this.entriesForCycleMask = -1L >>> -this.entriesForCycleBits;
    }

    void checkNotClosed() {
        if (this.closed) {
            throw new IllegalStateException(this.basePath + " is closed");
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    public int getEntriesForCycleBits() {
        return this.entriesForCycleBits;
    }

    BytesMarshallerFactory acquireBMF() {
        WeakReference<BytesMarshallerFactory> bmfRef = this.marshallersCache.get();
        BytesMarshallerFactory bmf = null;
        if (bmfRef != null) {
            bmf = (BytesMarshallerFactory)bmfRef.get();
        }
        if (bmf == null) {
            bmf = this.createBMF();
            this.marshallersCache.set(new WeakReference<BytesMarshallerFactory>(bmf));
        }
        return bmf;
    }

    BytesMarshallerFactory createBMF() {
        return new VanillaBytesMarshallerFactory();
    }

    public long lastIndex() {
        int cycle = (int)this.indexCache.lastCycle();
        int lastIndexFile = this.indexCache.lastIndexFile(cycle, -1);
        if (lastIndexFile >= 0) {
            try {
                VanillaMappedBytes buffer = this.indexCache.indexFor(cycle, lastIndexFile, false);
                long indices = VanillaIndexCache.countIndices(buffer);
                buffer.release();
                return (long)cycle * this.config.entriesPerCycle() + (indices > 0L ? indices - 1L : 0L);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
        return -1L;
    }

    @Override
    @NotNull
    public ExcerptTailer createTailer() throws IOException {
        WeakReference<VanillaTailer> ref = this.tailerCache.get();
        VanillaTailer tailer = null;
        if (ref != null && (tailer = (VanillaTailer)ref.get()) != null && tailer.unampped()) {
            tailer = null;
        }
        if (tailer == null) {
            tailer = this.createTailer0();
            this.tailerCache.set(new WeakReference<VanillaTailer>(tailer));
        }
        return tailer;
    }

    private VanillaTailer createTailer0() {
        return new VanillaTailerImpl();
    }

    @Override
    @NotNull
    public VanillaAppender createAppender() throws IOException {
        WeakReference<VanillaAppender> ref = this.appenderCache.get();
        VanillaAppender appender = null;
        if (ref != null && (appender = (VanillaAppender)ref.get()) != null && appender.unampped()) {
            appender = null;
        }
        if (appender == null) {
            appender = this.createAppender0();
            this.appenderCache.set(new WeakReference<VanillaAppender>(appender));
        }
        return appender;
    }

    private VanillaAppender createAppender0() {
        VanillaAppenderImpl appender = new VanillaAppenderImpl();
        return !this.config.useCheckedExcerpt() ? appender : new VanillaCheckedAppender(appender);
    }

    @Override
    @NotNull
    public Excerpt createExcerpt() throws IOException {
        Excerpt excerpt = this.config.useCheckedExcerpt() ? new VanillaExcerpt() : new VanillaCheckedExcerpt(new VanillaExcerpt());
        return excerpt;
    }

    @Override
    public long lastWrittenIndex() {
        return this.lastWrittenIndex;
    }

    @Override
    public long size() {
        return this.lastWrittenIndex + 1L;
    }

    @Override
    public void close() {
        this.closed = true;
        this.indexCache.close();
        this.dataCache.close();
    }

    @Override
    public void clear() {
        this.indexCache.close();
        this.dataCache.close();
        IOTools.deleteDir((String)this.basePath);
    }

    public void checkCounts(int min, int max) {
        this.indexCache.checkCounts(min, max);
        this.dataCache.checkCounts(min, max);
    }

    final class VanillaCheckedAppender
    extends CheckedExcerpt
    implements VanillaAppender {
        public VanillaCheckedAppender(VanillaAppender common) {
            super(common);
        }

        @Override
        public boolean unampped() {
            return ((VanillaExcerptCommon)this.common).unampped();
        }

        @Override
        public void startExcerpt(long capacity, int cycle) {
            ((VanillaAppender)this.common).startExcerpt(capacity, cycle);
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }

    final class VanillaCheckedExcerpt
    extends CheckedExcerpt
    implements VanillaExcerptCommon {
        public VanillaCheckedExcerpt(VanillaExcerptCommon common) {
            super(common);
        }

        @Override
        public boolean unampped() {
            return ((VanillaExcerptCommon)this.common).unampped();
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }

    class VanillaTailerImpl
    extends AbstractVanillaExcerpt
    implements VanillaTailer {
        VanillaTailerImpl() {
        }

        @Override
        @NotNull
        public ExcerptTailer toStart() {
            super.toStart();
            return this;
        }

        @Override
        @NotNull
        public ExcerptTailer toEnd() {
            super.toEnd();
            return this;
        }

        public long capacity() {
            return this.limitAddr - this.startAddr;
        }
    }

    public class VanillaAppenderImpl
    extends AbstractVanillaExcerpt
    implements VanillaAppender {
        private int lastCycle;
        private int lastThreadId;
        private int appenderCycle;
        private int appenderThreadId;
        private boolean nextSynchronous;

        VanillaAppenderImpl() {
            this.lastCycle = Integer.MIN_VALUE;
            this.lastThreadId = Integer.MIN_VALUE;
        }

        @Override
        public void startExcerpt() {
            this.startExcerpt(VanillaChronicle.this.config.defaultMessageSize());
        }

        @Override
        public void startExcerpt(long capacity) {
            this.startExcerpt(capacity, this.cycle());
        }

        @Override
        public void startExcerpt(long capacity, int cycle) {
            VanillaChronicle.this.checkNotClosed();
            try {
                this.appenderCycle = cycle;
                this.appenderThreadId = AffinitySupport.getThreadId();
                assert (((long)this.appenderThreadId & VanillaChronicleConfig.THREAD_ID_MASK) == (long)this.appenderThreadId) : "appenderThreadId: " + this.appenderThreadId;
                if (this.appenderCycle != this.lastCycle || this.appenderThreadId != this.lastThreadId) {
                    if (this.dataBytes != null) {
                        this.dataBytes.release();
                        this.dataBytes = null;
                    }
                    if (this.indexBytes != null) {
                        this.indexBytes.release();
                        this.indexBytes = null;
                    }
                    this.dataBytes = VanillaChronicle.this.dataCache.dataForLast(this.appenderCycle, this.appenderThreadId);
                    this.lastCycle = this.appenderCycle;
                    this.lastThreadId = this.appenderThreadId;
                }
                if (this.dataBytes.remaining() < capacity + 4L) {
                    VanillaChronicle.this.dataCache.incrementLastCount();
                    this.dataBytes.release();
                    this.dataBytes = null;
                    this.dataBytes = VanillaChronicle.this.dataCache.dataForLast(this.appenderCycle, this.appenderThreadId);
                }
                this.startAddr = this.positionAddr = this.dataBytes.positionAddr() + 4L;
                this.limitAddr = this.startAddr + capacity;
                this.nextSynchronous = VanillaChronicle.this.config.synchronous();
                this.finished = false;
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public void addPaddedEntry() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean nextSynchronous() {
            return this.nextSynchronous;
        }

        @Override
        public void nextSynchronous(boolean nextSynchronous) {
            this.nextSynchronous = nextSynchronous;
        }

        @Override
        public void finish() {
            super.finish();
            int length = ~((int)(this.positionAddr - this.startAddr));
            NativeBytes.UNSAFE.putOrderedInt(null, this.startAddr - 4L, length);
            int offset = (int)(this.startAddr - this.dataBytes.address());
            long dataOffset = this.dataBytes.index() * VanillaChronicle.this.config.dataBlockSize() + (long)offset;
            long indexValue = ((long)this.appenderThreadId << VanillaChronicleConfig.INDEX_DATA_OFFSET_BITS) + dataOffset;
            VanillaChronicle.this.lastWrittenIndex = indexValue;
            try {
                if (!VanillaIndexCache.append(this.indexBytes, indexValue, this.nextSynchronous)) {
                    if (this.indexBytes != null) {
                        this.indexBytes.release();
                        this.indexBytes = null;
                    }
                    this.indexBytes = VanillaChronicle.this.indexCache.append(this.appenderCycle, indexValue, this.nextSynchronous);
                }
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            this.dataBytes.positionAddr(this.positionAddr);
            this.dataBytes.alignPositionAddr(4);
            if (this.nextSynchronous) {
                this.dataBytes.force();
            }
        }

        @Override
        @NotNull
        public ExcerptAppender toEnd() {
            return this;
        }
    }

    class VanillaExcerpt
    extends AbstractVanillaExcerpt
    implements Excerpt {
        VanillaExcerpt() {
        }

        @Override
        public long findMatch(@NotNull ExcerptComparator comparator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void findRange(@NotNull long[] startEnd, @NotNull ExcerptComparator comparator) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Excerpt toStart() {
            super.toStart();
            return this;
        }

        @Override
        @NotNull
        public Excerpt toEnd() {
            super.toEnd();
            return this;
        }
    }

    abstract class AbstractVanillaExcerpt
    extends NativeBytes
    implements VanillaExcerptCommon {
        private long index;
        private int lastCycle;
        private int lastDailyCount;
        private int lastThreadId;
        private int lastDataCount;
        protected VanillaMappedBytes indexBytes;
        protected VanillaMappedBytes dataBytes;

        public AbstractVanillaExcerpt() {
            super(VanillaChronicle.this.acquireBMF(), NO_PAGE, NO_PAGE, null);
            this.index = -1L;
            this.lastCycle = Integer.MIN_VALUE;
            this.lastDailyCount = Integer.MIN_VALUE;
            this.lastThreadId = Integer.MIN_VALUE;
            this.lastDataCount = Integer.MIN_VALUE;
            this.indexBytes = null;
            this.dataBytes = null;
        }

        @Override
        public boolean unampped() {
            return this.indexBytes != null && this.dataBytes != null ? this.indexBytes.unmapped() && this.dataBytes.unmapped() : true;
        }

        @Override
        public boolean wasPadding() {
            return false;
        }

        @Override
        public long index() {
            return this.index;
        }

        @Override
        public long lastWrittenIndex() {
            return VanillaChronicle.this.lastWrittenIndex();
        }

        @Override
        public long size() {
            return this.lastWrittenIndex() + 1L;
        }

        @Override
        public Chronicle chronicle() {
            return VanillaChronicle.this;
        }

        public int cycle() {
            return (int)(System.currentTimeMillis() / (long)VanillaChronicle.this.config.cycleLength());
        }

        public boolean index(long nextIndex) {
            VanillaChronicle.this.checkNotClosed();
            try {
                int len;
                long indexValue;
                int cycle = (int)(nextIndex >>> VanillaChronicle.this.entriesForCycleBits);
                int dailyCount = (int)((nextIndex & VanillaChronicle.this.entriesForCycleMask) >>> VanillaChronicle.this.indexBlockLongsBits);
                int dailyOffset = (int)(nextIndex & (long)VanillaChronicle.this.indexBlockLongsMask);
                boolean indexFileChange = false;
                try {
                    if (this.lastCycle != cycle || this.lastDailyCount != dailyCount || this.indexBytes == null) {
                        if (this.indexBytes != null) {
                            this.indexBytes.release();
                            this.indexBytes = null;
                        }
                        if (this.dataBytes != null) {
                            this.dataBytes.release();
                            this.dataBytes = null;
                        }
                        this.indexBytes = VanillaChronicle.this.indexCache.indexFor(cycle, dailyCount, false);
                        indexFileChange = true;
                        assert (this.indexBytes.refCount() > 1);
                        this.lastCycle = cycle;
                        this.lastDailyCount = dailyCount;
                    }
                    indexValue = this.indexBytes.readVolatileLong((long)(dailyOffset << 3));
                }
                catch (FileNotFoundException e) {
                    return false;
                }
                if (indexValue == 0L) {
                    return false;
                }
                int threadId = (int)(indexValue >>> VanillaChronicleConfig.INDEX_DATA_OFFSET_BITS);
                long dataOffset0 = indexValue & VanillaChronicleConfig.INDEX_DATA_OFFSET_MASK;
                int dataCount = (int)(dataOffset0 >>> VanillaChronicle.this.dataBlockSizeBits);
                int dataOffset = (int)(dataOffset0 & (long)VanillaChronicle.this.dataBlockSizeMask);
                if ((this.lastThreadId != threadId || this.lastDataCount != dataCount || indexFileChange) && this.dataBytes != null) {
                    this.dataBytes.release();
                    this.dataBytes = null;
                }
                if (this.dataBytes == null) {
                    this.dataBytes = VanillaChronicle.this.dataCache.dataFor(cycle, threadId, dataCount, false);
                    this.lastThreadId = threadId;
                    this.lastDataCount = dataCount;
                }
                if ((len = this.dataBytes.readVolatileInt((long)(dataOffset - 4))) == 0) {
                    return false;
                }
                int len2 = ~len;
                if (len2 >>> 30 != 0) {
                    throw new IllegalStateException("Corrupted length " + Integer.toHexString(len));
                }
                this.startAddr = this.positionAddr = this.dataBytes.startAddr() + (long)dataOffset;
                this.limitAddr = this.startAddr + (long)(~len);
                this.index = nextIndex;
                this.finished = false;
                return true;
            }
            catch (IOException ioe) {
                throw new AssertionError((Object)ioe);
            }
        }

        public boolean nextIndex() {
            VanillaChronicle.this.checkNotClosed();
            if (this.index < 0L) {
                this.toStart();
                if (this.index < 0L) {
                    return false;
                }
            }
            long nextIndex = this.index + 1L;
            boolean found;
            while (!(found = this.index(nextIndex))) {
                int cycle = (int)(nextIndex / VanillaChronicle.this.config.entriesPerCycle());
                if (cycle >= this.cycle()) {
                    return false;
                }
                nextIndex = (long)(cycle + 1) * VanillaChronicle.this.config.entriesPerCycle();
            }
            return true;
        }

        @NotNull
        public ExcerptCommon toStart() {
            int cycle = (int)VanillaChronicle.this.indexCache.firstCycle();
            if (cycle >= 0) {
                this.index = (long)cycle * VanillaChronicle.this.config.entriesPerCycle() - 1L;
            }
            return this;
        }

        @Override
        @NotNull
        public ExcerptCommon toEnd() {
            long lastIndex = VanillaChronicle.this.lastIndex();
            if (lastIndex < 0L) {
                return this.toStart();
            }
            this.index(lastIndex);
            return this;
        }

        public void close() {
            if (this.indexBytes != null) {
                this.indexBytes.release();
                this.indexBytes = null;
            }
            if (this.dataBytes != null) {
                this.dataBytes.release();
                this.dataBytes = null;
            }
            super.close();
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }

    public static interface VanillaTailer
    extends VanillaExcerptCommon,
    ExcerptTailer {
    }

    public static interface VanillaAppender
    extends VanillaExcerptCommon,
    ExcerptAppender {
        public void startExcerpt(long var1, int var3);
    }

    public static interface VanillaExcerptCommon
    extends ExcerptCommon {
        public boolean unampped();
    }
}

