/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle;

import java.util.concurrent.TimeUnit;
import net.openhft.lang.Jvm;
import net.openhft.lang.model.constraints.NotNull;

public class VanillaChronicleConfig
implements Cloneable {
    public static final VanillaChronicleConfig DEFAULT = new VanillaChronicleConfig();
    public static final long MIN_CYCLE_LENGTH = TimeUnit.HOURS.toMillis(1L);
    public static final int THREAD_ID_BITS = Integer.getInteger("os.max.pid.bits", Jvm.PID_BITS);
    public static final long THREAD_ID_MASK = -1L >>> -THREAD_ID_BITS;
    public static final int INDEX_DATA_OFFSET_BITS = 64 - THREAD_ID_BITS;
    public static final long INDEX_DATA_OFFSET_MASK = -1L >>> -INDEX_DATA_OFFSET_BITS;
    private String cycleFormat = "yyyyMMdd";
    private int cycleLength = 86400000;
    private long indexBlockSize = 0x1000000L;
    private long dataBlockSize = 0x4000000L;
    private int defaultMessageSize = 131072;
    private long entriesPerCycle = 0x10000000000L;
    private boolean synchronous = false;
    private boolean cleanupOnClose = false;
    private int dataCacheCapacity = 32;
    private int indexCacheCapacity = 32;
    private boolean useCheckedExcerpt = false;

    public VanillaChronicleConfig cycleFormat(String cycleFormat) {
        this.cycleFormat = cycleFormat;
        return this;
    }

    public String cycleFormat() {
        return this.cycleFormat;
    }

    public VanillaChronicleConfig cycleLength(int cycleLength) {
        return this.cycleLength(cycleLength, true);
    }

    public VanillaChronicleConfig cycleLength(int cycleLength, boolean check) {
        if (check && (long)cycleLength < MIN_CYCLE_LENGTH) {
            throw new IllegalArgumentException("Cycle length can't be less than " + MIN_CYCLE_LENGTH + " ms!");
        }
        this.cycleLength = cycleLength;
        return this;
    }

    public int cycleLength() {
        return this.cycleLength;
    }

    public VanillaChronicleConfig indexBlockSize(long indexBlockSize) {
        this.indexBlockSize = indexBlockSize;
        return this;
    }

    public long indexBlockSize() {
        return this.indexBlockSize;
    }

    public long dataBlockSize() {
        return this.dataBlockSize;
    }

    public VanillaChronicleConfig dataBlockSize(int dataBlockSize) {
        this.dataBlockSize = dataBlockSize;
        return this;
    }

    public VanillaChronicleConfig entriesPerCycle(long entriesPerCycle) {
        if (entriesPerCycle < 256L) {
            throw new IllegalArgumentException("EntriesPerCycle must be at least 256");
        }
        if (entriesPerCycle > 0x1000000000000L) {
            throw new IllegalArgumentException("EntriesPerCycle must not exceed 1L << 48 (281474976710656)");
        }
        if ((entriesPerCycle & -entriesPerCycle) != entriesPerCycle) {
            throw new IllegalArgumentException("EntriesPerCycle must be a power of 2");
        }
        this.entriesPerCycle = entriesPerCycle;
        return this;
    }

    public long entriesPerCycle() {
        return this.entriesPerCycle;
    }

    public VanillaChronicleConfig defaultMessageSize(int defaultMessageSize) {
        this.defaultMessageSize = defaultMessageSize;
        return this;
    }

    public int defaultMessageSize() {
        return this.defaultMessageSize;
    }

    public VanillaChronicleConfig synchronous(boolean synchronous) {
        this.synchronous = synchronous;
        return this;
    }

    public boolean synchronous() {
        return this.synchronous;
    }

    public VanillaChronicleConfig cleanupOnClose(boolean cleanupOnClose) {
        this.cleanupOnClose = cleanupOnClose;
        return this;
    }

    public boolean cleanupOnClose() {
        return this.cleanupOnClose;
    }

    public VanillaChronicleConfig dataCacheCapacity(int dataCacheCapacity) {
        this.dataCacheCapacity = dataCacheCapacity;
        return this;
    }

    public int dataCacheCapacity() {
        return this.dataCacheCapacity;
    }

    public VanillaChronicleConfig indexCacheCapacity(int indexCacheCapacity) {
        this.indexCacheCapacity = indexCacheCapacity;
        return this;
    }

    public int indexCacheCapacity() {
        return this.indexCacheCapacity;
    }

    public boolean useCheckedExcerpt() {
        return this.useCheckedExcerpt;
    }

    public VanillaChronicleConfig useCheckedExcerpt(boolean useCheckedExcerpt) {
        this.useCheckedExcerpt = useCheckedExcerpt;
        return this;
    }

    @NotNull
    public VanillaChronicleConfig clone() {
        try {
            return (VanillaChronicleConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }
}

