/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import net.openhft.chronicle.DateCache;
import net.openhft.chronicle.VanillaChronicleConfig;
import net.openhft.chronicle.VanillaChronicleUtils;
import net.openhft.lang.io.VanillaMappedBytes;
import net.openhft.lang.io.VanillaMappedCache;
import net.openhft.lang.model.constraints.NotNull;

public class VanillaIndexCache
implements Closeable {
    private static final String FILE_NAME_PREFIX = "index-";
    private final String basePath;
    private final File baseFile;
    private final IndexKey key = new IndexKey();
    private final int blockBits;
    private final DateCache dateCache;
    private final VanillaMappedCache<IndexKey> cache;

    public VanillaIndexCache(@NotNull String basePath, int blockBits, @NotNull DateCache dateCache) {
        this(basePath, blockBits, dateCache, VanillaChronicleConfig.DEFAULT);
    }

    public VanillaIndexCache(@NotNull String basePath, int blockBits, @NotNull DateCache dateCache, @NotNull VanillaChronicleConfig config) {
        this(basePath, blockBits, dateCache, config.indexCacheCapacity(), config.cleanupOnClose());
    }

    public VanillaIndexCache(@NotNull String basePath, int blockBits, @NotNull DateCache dateCache, int capacity) {
        this(basePath, blockBits, dateCache, capacity, false);
    }

    public VanillaIndexCache(@NotNull String basePath, int blockBits, @NotNull DateCache dateCache, int capacity, boolean cleanupOnClose) {
        this.basePath = basePath;
        this.baseFile = new File(basePath);
        this.blockBits = blockBits;
        this.dateCache = dateCache;
        this.cache = new VanillaMappedCache(capacity, true, cleanupOnClose);
    }

    public File fileFor(int cycle, int indexCount, boolean forAppend) throws IOException {
        return new File(new File(this.basePath, this.dateCache.formatFor(cycle)), FILE_NAME_PREFIX + indexCount);
    }

    public synchronized VanillaMappedBytes indexFor(int cycle, int indexCount, boolean forAppend) throws IOException {
        this.key.cycle = cycle;
        this.key.indexCount = indexCount << this.blockBits;
        VanillaMappedBytes vmb = this.cache.get((Object)this.key);
        if (vmb == null) {
            vmb = this.cache.put((Object)this.key.clone(), VanillaChronicleUtils.mkFiles(this.basePath, this.dateCache.formatFor(cycle), FILE_NAME_PREFIX + indexCount, forAppend), 1L << this.blockBits, (long)indexCount);
        }
        vmb.reserve();
        return vmb;
    }

    @Override
    public synchronized void close() {
        this.cache.close();
    }

    int lastIndexFile(int cycle) {
        return this.lastIndexFile(cycle, 0);
    }

    int lastIndexFile(int cycle, int defaultCycle) {
        int maxIndex = -1;
        File cyclePath = new File(this.baseFile, this.dateCache.formatFor(cycle));
        File[] files = cyclePath.listFiles();
        if (files != null) {
            for (File file : files) {
                int index;
                String name = file.getName();
                if (!name.startsWith(FILE_NAME_PREFIX) || maxIndex >= (index = Integer.parseInt(name.substring(FILE_NAME_PREFIX.length())))) continue;
                maxIndex = index;
            }
        }
        return maxIndex != -1 ? maxIndex : defaultCycle;
    }

    public VanillaMappedBytes append(int cycle, long indexValue, boolean synchronous) throws IOException {
        for (int indexCount = this.lastIndexFile(cycle, 0); indexCount < 10000; ++indexCount) {
            VanillaMappedBytes vmb = this.indexFor(cycle, indexCount, true);
            if (VanillaIndexCache.append(vmb, indexValue, synchronous)) {
                return vmb;
            }
            vmb.release();
        }
        throw new AssertionError();
    }

    public static boolean append(VanillaMappedBytes bytes, long indexValue, boolean synchronous) {
        if (bytes != null) {
            boolean endOfFile = false;
            while (!endOfFile) {
                long position = bytes.position();
                endOfFile = bytes.limit() - position < 8L;
                if (endOfFile) continue;
                if (bytes.compareAndSwapLong(position, 0L, indexValue)) {
                    if (synchronous) {
                        bytes.force();
                    }
                    return true;
                }
                bytes.position(position + 8L);
            }
        }
        return false;
    }

    public static long countIndices(VanillaMappedBytes buffer) {
        long indices = 0L;
        long offset = 0L;
        while (buffer.limit() - buffer.address() + offset < 8L && buffer.readLong(offset) != 0L) {
            ++indices;
            offset += 8L;
        }
        return indices;
    }

    public long firstCycle() {
        File[] files = this.baseFile.listFiles();
        if (files == null) {
            return -1L;
        }
        long firstDate = Long.MAX_VALUE;
        for (File file : files) {
            try {
                long date = this.dateCache.parseCount(file.getName());
                if (firstDate <= date) continue;
                firstDate = date;
            }
            catch (ParseException ignored) {
                // empty catch block
            }
        }
        return firstDate;
    }

    public long lastCycle() {
        File[] files = this.baseFile.listFiles();
        if (files == null) {
            return -1L;
        }
        long firstDate = Long.MIN_VALUE;
        for (File file : files) {
            try {
                long date = this.dateCache.parseCount(file.getName());
                if (firstDate >= date) continue;
                firstDate = date;
            }
            catch (ParseException ignored) {
                // empty catch block
            }
        }
        return firstDate;
    }

    public void checkCounts(int min, int max) {
        this.cache.checkCounts(min, max);
    }

    static class IndexKey
    implements Cloneable {
        int cycle;
        int indexCount;

        IndexKey() {
        }

        public int hashCode() {
            return this.cycle * 10191 ^ this.indexCount;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof IndexKey)) {
                return false;
            }
            IndexKey key = (IndexKey)obj;
            return this.indexCount == key.indexCount && this.cycle == key.cycle;
        }

        protected IndexKey clone() {
            try {
                return (IndexKey)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

