/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.tcp;

import net.openhft.lang.model.constraints.NotNull;

public class ChronicleSourceConfig
implements Cloneable {
    public static final ChronicleSourceConfig DEFAULT = new ChronicleSourceConfig();
    private int maxMessages = 128;
    private int minBufferSize = 262144;
    private long heartbeatInterval = 2500L;
    private long selectTimeout = 0L;

    private ChronicleSourceConfig() {
    }

    public ChronicleSourceConfig maxMessages(int maxMessages) {
        this.maxMessages = maxMessages;
        return this;
    }

    public int maxMessages() {
        return this.maxMessages;
    }

    public ChronicleSourceConfig minBufferSize(int minBufferSize) {
        this.minBufferSize = minBufferSize;
        return this;
    }

    public int minBufferSize() {
        return this.minBufferSize;
    }

    public ChronicleSourceConfig heartbeatInterval(long heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
        return this;
    }

    public long heartbeatInterval() {
        return this.heartbeatInterval;
    }

    public ChronicleSourceConfig selectTimeout(long selectTimeout) {
        if (selectTimeout < 0L) {
            throw new IllegalArgumentException("SelectTimeout must be >= 0");
        }
        this.selectTimeout = selectTimeout;
        return this;
    }

    public long selectTimeout() {
        return this.selectTimeout;
    }

    @NotNull
    public ChronicleSourceConfig clone() {
        try {
            return (ChronicleSourceConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }
}

