/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.tcp;

import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;
import net.openhft.lang.model.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChronicleTcp {
    public static final Logger LOG = LoggerFactory.getLogger(ChronicleTcp.class);
    public static final int HEADER_SIZE = 12;
    public static final int INITIAL_BUFFER_SIZE = 65536;
    public static final int IN_SYNC_LEN = -128;
    public static final int PADDED_LEN = -127;
    public static final int SYNC_IDX_LEN = -126;

    public static ByteBuffer createBuffer(int minSize, ByteOrder byteOrder) {
        int newSize = (minSize + 65536 - 1) / 65536 * 65536;
        return ByteBuffer.allocateDirect(newSize).order(byteOrder);
    }

    public static void writeAllOrEOF(@NotNull SocketChannel sc, @NotNull ByteBuffer bb) throws IOException {
        ChronicleTcp.writeAll(sc, bb);
        if (bb.remaining() > 0) {
            throw new EOFException();
        }
    }

    public static void writeAll(@NotNull SocketChannel sc, @NotNull ByteBuffer bb) throws IOException {
        while (bb.remaining() > 0 && sc.write(bb) >= 0) {
        }
    }

    public static void readFullyOrEOF(@NotNull SocketChannel socket, @NotNull ByteBuffer bb) throws IOException {
        ChronicleTcp.readAvailable(socket, bb);
        if (bb.remaining() > 0) {
            throw new EOFException();
        }
    }

    private static void readAvailable(@NotNull SocketChannel socket, @NotNull ByteBuffer bb) throws IOException {
        while (bb.remaining() > 0 && socket.read(bb) >= 0) {
        }
    }

    public static boolean isLocalhost(InetAddress address) {
        if (address.isLoopbackAddress()) {
            return true;
        }
        try {
            return NetworkInterface.getByInetAddress(address) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static final class Command {
        public static final long ACTION_SUBSCRIBE = 1L;
        public static final long ACTION_QUERY = 2L;
        private ByteBuffer buffer;
        private long action;
        private long data;

        public Command() {
            this(0L, 0L);
        }

        private Command(long action, long data) {
            this.action = action;
            this.data = data;
            this.buffer = ByteBuffer.allocate(16).order(ByteOrder.nativeOrder()).putLong(action).putLong(data);
        }

        public long action() {
            return this.action;
        }

        public long data() {
            return this.data;
        }

        public boolean read(SocketChannel channel) throws IOException {
            this.buffer.clear();
            ChronicleTcp.readFullyOrEOF(channel, this.buffer);
            this.buffer.flip();
            this.action = this.buffer.getLong();
            this.data = this.buffer.getLong();
            return true;
        }

        public boolean write(SocketChannel channel) throws IOException {
            this.buffer.flip();
            ChronicleTcp.writeAllOrEOF(channel, this.buffer);
            return true;
        }

        public boolean isSubscribe() {
            return this.action == 1L;
        }

        public boolean isQuery() {
            return this.action == 2L;
        }

        public static Command make(long action, long data) {
            return new Command(action, data);
        }

        public static boolean makeAndSend(long action, long data, SocketChannel channel) throws IOException {
            return new Command(action, data).write(channel);
        }
    }
}

