/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.tools;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.LinkedHashSet;
import java.util.Set;
import net.openhft.chronicle.ExcerptCommon;
import net.openhft.chronicle.tools.ChronicleWarmup;
import net.openhft.lang.io.IOTools;
import net.openhft.lang.model.constraints.NotNull;

public enum ChronicleTools {


    public static void deleteOnExit(String basePath) {
        for (String name : new String[]{basePath + ".data", basePath + ".index"}) {
            File file = new File(name);
            file.delete();
            file.deleteOnExit();
        }
    }

    public static void deleteDirOnExit(String dirPath) {
        DeleteStatic.INSTANCE.add(dirPath);
    }

    @NotNull
    public static String asString(@NotNull ByteBuffer bb) {
        StringBuilder sb = new StringBuilder();
        for (int i = bb.position(); i < bb.limit(); ++i) {
            byte b = bb.get(i);
            if (b < 32) {
                int h = b & 0xFF;
                if (h < 16) {
                    sb.append('0');
                }
                sb.append(Integer.toHexString(h));
                continue;
            }
            sb.append(' ').append((char)b);
        }
        return sb.toString();
    }

    @NotNull
    public static String asString(@NotNull ExcerptCommon excerpt) {
        return ChronicleTools.asString(excerpt, excerpt.position());
    }

    @NotNull
    private static String asString(@NotNull ExcerptCommon excerpt, long position) {
        return ChronicleTools.asString(excerpt, position, 1024L);
    }

    @NotNull
    private static String asString(@NotNull ExcerptCommon excerpt, long position, long length) {
        long limit = Math.min(position + length, excerpt.capacity());
        StringBuilder sb = new StringBuilder((int)(limit - position));
        for (long i = position; i < limit; ++i) {
            char ch = (char)excerpt.readUnsignedByte(i);
            if (ch < ' ' || ch > '\u007f') {
                ch = '.';
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static void warmup() {
        boolean done = ChronicleWarmup.DONE;
    }

    static enum DeleteStatic {
        INSTANCE;

        final Set<String> toDeleteList = new LinkedHashSet<String>();

        private DeleteStatic() {
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    for (String dir : DeleteStatic.this.toDeleteList) {
                        System.out.println("Deleting " + dir.replaceAll("/", "//"));
                        IOTools.deleteDir((String)dir);
                    }
                }
            }));
        }

        synchronized void add(String dirPath) {
            IOTools.deleteDir((String)dirPath);
            this.toDeleteList.add(dirPath);
        }
    }
}

