/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MasterIndexFile {
    private final File file;
    private final List<String> filenames = new ArrayList<String>();

    public MasterIndexFile(File file) {
        this.file = file;
        this.loadFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFile() {
        try {
            if (!this.file.exists()) {
                return;
            }
            BufferedReader br = new BufferedReader(new FileReader(this.file));
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    this.filenames.add(line.trim().isEmpty() ? null : line);
                }
            }
            finally {
                br.close();
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new AssertionError((Object)fnfe);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public String filenameFor(int index) {
        if (this.filenames.size() <= index) {
            return null;
        }
        return this.filenames.get(index);
    }

    public int append(String filenameAdded) throws IOException {
        int index = this.filenames.indexOf(filenameAdded);
        if (index >= 0) {
            return index;
        }
        this.filenames.add(filenameAdded);
        FileWriter fileWriter = new FileWriter(this.file);
        fileWriter.append(filenameAdded).append("\n");
        fileWriter.close();
        return this.filenames.size() - 1;
    }

    public void close() {
    }

    public int size() {
        return this.filenames.size();
    }
}

