/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import net.openhft.lang.io.DirectBytes;
import net.openhft.lang.io.NativeBytes;
import net.openhft.lang.io.serialization.BytesMarshallerFactory;
import net.openhft.lang.io.serialization.impl.VanillaBytesMarshallerFactory;
import org.jetbrains.annotations.NotNull;
import sun.misc.Cleaner;

public class DirectStore {
    protected BytesMarshallerFactory bytesMarshallerFactory;
    private final Cleaner cleaner;
    protected long address;
    protected long size;

    public DirectStore(long size) {
        this(new VanillaBytesMarshallerFactory(), size);
    }

    public DirectStore(BytesMarshallerFactory bytesMarshallerFactory, long size) {
        this(bytesMarshallerFactory, size, true);
    }

    public DirectStore(BytesMarshallerFactory bytesMarshallerFactory, long size, boolean zeroOut) {
        this.bytesMarshallerFactory = bytesMarshallerFactory;
        this.address = NativeBytes.UNSAFE.allocateMemory(size);
        if (zeroOut) {
            NativeBytes.UNSAFE.setMemory(this.address, size, (byte)0);
            NativeBytes.UNSAFE.putLongVolatile(null, this.address, 0L);
        }
        this.size = size;
        this.cleaner = Cleaner.create((Object)this, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (DirectStore.this.address != 0L) {
                    NativeBytes.UNSAFE.freeMemory(DirectStore.this.address);
                }
                DirectStore.this.size = 0L;
                DirectStore.this.address = 0L;
            }
        });
    }

    @NotNull
    public static DirectStore allocate(long size) {
        return new DirectStore(null, size);
    }

    @NotNull
    public static DirectStore allocateLazy(long size) {
        return new DirectStore(null, size, false);
    }

    @NotNull
    public DirectBytes createSlice() {
        return new DirectBytes(this);
    }

    public void free() {
        this.cleaner.clean();
    }

    public long size() {
        return this.size;
    }

    public BytesMarshallerFactory bytesMarshallerFactory() {
        return this.bytesMarshallerFactory;
    }
}

