/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.serialization.direct;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.openhft.lang.Maths;
import net.openhft.lang.io.NativeBytes;
import net.openhft.lang.io.serialization.direct.FieldMetadata;

public class Introspect {
    public static List<Field> fields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Introspect.addToFields(clazz, fields);
        Collections.sort(fields, FieldOffsetComparator.Instance);
        return fields;
    }

    private static List<Field> addToFields(Class<?> clazz, ArrayList<Field> accumulator) {
        Collections.addAll(accumulator, clazz.getDeclaredFields());
        Class<?> maybeSuper = clazz.getSuperclass();
        return maybeSuper != null ? Introspect.addToFields(maybeSuper, accumulator) : accumulator;
    }

    private static final class FieldOffsetComparator
    implements Comparator<Field> {
        public static final FieldOffsetComparator Instance = new FieldOffsetComparator();

        private FieldOffsetComparator() {
        }

        @Override
        public int compare(Field first, Field second) {
            return Maths.compare(FieldOffsetComparator.offset(first), FieldOffsetComparator.offset(second));
        }

        private static long offset(Field field) {
            return FieldMetadata.isStatic(field) ? NativeBytes.UNSAFE.staticFieldOffset(field) : NativeBytes.UNSAFE.objectFieldOffset(field);
        }
    }
}

