/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.io.EOFException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicInteger;
import net.openhft.lang.io.AbstractBytes;
import net.openhft.lang.io.ByteBufferReuse;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.ChronicleUnsafe;
import net.openhft.lang.io.MappedFile;
import net.openhft.lang.io.RandomDataInput;
import net.openhft.lang.io.serialization.ObjectSerializer;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;

public class MappedNativeBytes
extends AbstractBytes {
    @NotNull
    public final ThreadLocal<ChronicleUnsafe> threadLocal = new ThreadLocal();
    static final int BYTES_OFFSET;
    static final int CHARS_OFFSET;
    private final boolean isSingleThreaded;
    protected long start;
    protected long position;
    protected long limit;
    protected long capacity;
    private final MappedFile mappedFile;
    private final ChronicleUnsafe chronicleUnsafe;

    public MappedNativeBytes(@NotNull MappedFile mappedFile, boolean isSingleThreaded) {
        this.isSingleThreaded = isSingleThreaded;
        this.mappedFile = mappedFile;
        this.position = this.start = 0L;
        this.capacity = Long.MAX_VALUE;
        this.limit = Long.MAX_VALUE;
        this.chronicleUnsafe = isSingleThreaded ? new ChronicleUnsafe(mappedFile) : null;
    }

    public MappedNativeBytes(ObjectSerializer objectSerializer, long sliceStart, long capacity, @NotNull AtomicInteger refCount, @NotNull MappedFile mappedFile, boolean singleThreaded) {
        this.isSingleThreaded = singleThreaded;
        this.objectSerializer = objectSerializer;
        this.start = sliceStart;
        this.position = 0L;
        this.capacity = capacity;
        this.refCount.set(refCount.get());
        this.mappedFile = mappedFile;
        this.chronicleUnsafe = this.isSingleThreaded ? new ChronicleUnsafe(mappedFile) : null;
    }

    @Override
    public MappedNativeBytes slice() {
        return new MappedNativeBytes(this.objectSerializer(), this.position, this.limit, this.refCount, this.mappedFile, this.isSingleThreaded);
    }

    @Override
    public MappedNativeBytes slice(long offset, long length) {
        long sliceStart = this.position + offset;
        assert (sliceStart >= this.start && sliceStart < this.capacity);
        long sliceEnd = sliceStart + length;
        assert (sliceEnd > sliceStart && sliceEnd <= this.capacity);
        return new MappedNativeBytes(this.objectSerializer(), sliceStart, sliceEnd, this.refCount, this.mappedFile, this.isSingleThreaded);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        long subStart = this.position + (long)start;
        if (subStart < this.position || subStart > this.limit) {
            throw new IndexOutOfBoundsException();
        }
        long subEnd = this.position + (long)end;
        if (subEnd < subStart || subEnd > this.limit) {
            throw new IndexOutOfBoundsException();
        }
        if (start == end) {
            return "";
        }
        return new MappedNativeBytes(this.objectSerializer(), subStart, subEnd, this.refCount, this.mappedFile, this.isSingleThreaded);
    }

    @Override
    public MappedNativeBytes bytes() {
        return new MappedNativeBytes(this.objectSerializer(), this.start, this.capacity, this.refCount, this.mappedFile, this.isSingleThreaded);
    }

    @Override
    public MappedNativeBytes bytes(long offset, long length) {
        long sliceStart = this.start + offset;
        assert (sliceStart >= this.start && sliceStart < this.capacity);
        long sliceEnd = sliceStart + length;
        assert (sliceEnd > sliceStart && sliceEnd <= this.capacity);
        return new MappedNativeBytes(this.objectSerializer(), sliceStart, sliceEnd, this.refCount, this.mappedFile, this.isSingleThreaded);
    }

    @Override
    public long address() {
        return this.start;
    }

    @Override
    public Bytes zeroOut() {
        this.clear();
        this.getChronicleUnsafe().setMemory(this.start, this.capacity(), (byte)0);
        return this;
    }

    @Override
    public Bytes zeroOut(long start, long end) {
        if (start < 0L || end > this.limit()) {
            throw new IllegalArgumentException("start: " + start + ", end: " + end);
        }
        if (start >= end) {
            return this;
        }
        this.getChronicleUnsafe().setMemory(this.start + start, end - start, (byte)0);
        return this;
    }

    @Override
    public Bytes zeroOut(long start, long end, boolean ifNotZero) {
        return ifNotZero ? this.zeroOutDirty(start, end) : this.zeroOut(start, end);
    }

    private Bytes zeroOutDirty(long start, long end) {
        if (start < 0L || end > this.limit()) {
            throw new IllegalArgumentException("start: " + start + ", end: " + end);
        }
        if (start >= end) {
            return this;
        }
        ChronicleUnsafe unsafe = this.getChronicleUnsafe();
        while (start < end && (start & 7L) != 0L) {
            byte b = unsafe.getByte(this.start + start);
            if (b != 0) {
                unsafe.putByte(this.start + start, (byte)0);
            }
            ++start;
        }
        while (start < end - 7L) {
            long l = unsafe.getLong(this.start + start);
            if (l != 0L) {
                unsafe.putLong(this.start + start, 0L);
            }
            ++start;
        }
        while (start < end) {
            byte b = unsafe.getByte(this.start + start);
            if (b != 0) {
                unsafe.putByte(this.start + start, (byte)0);
            }
            ++start;
        }
        return this;
    }

    @Override
    public int read(@NotNull byte[] bytes, int off, int len) {
        if (len < 0 || off < 0 || off + len > bytes.length) {
            throw new IllegalArgumentException();
        }
        long left = this.remaining();
        if (left <= 0L) {
            return -1;
        }
        int len2 = (int)Math.min((long)len, left);
        this.getChronicleUnsafe().copyMemory(null, this.position, bytes, BYTES_OFFSET + off, len2);
        this.addPosition(len2);
        return len2;
    }

    @Override
    public byte readByte() {
        byte aByte = this.getChronicleUnsafe().getByte(this.position);
        this.addPosition(1L);
        return aByte;
    }

    @Override
    public byte readByte(long offset) {
        return this.getChronicleUnsafe().getByte(this.start + offset);
    }

    @Override
    public void readFully(@NotNull byte[] b, int off, int len) {
        MappedNativeBytes.checkArrayOffs(b.length, off, len);
        long left = this.remaining();
        if (left < (long)len) {
            throw new IllegalStateException(new EOFException());
        }
        this.getChronicleUnsafe().copyMemory(null, this.position, b, BYTES_OFFSET + off, len);
        this.addPosition(len);
    }

    @Override
    public void readFully(long offset, byte[] bytes, int off, int len) {
        MappedNativeBytes.checkArrayOffs(bytes.length, off, len);
        this.getChronicleUnsafe().copyMemory(null, this.start + offset, bytes, BYTES_OFFSET + off, len);
    }

    @Override
    public void readFully(@NotNull char[] data, int off, int len) {
        MappedNativeBytes.checkArrayOffs(data.length, off, len);
        long bytesOff = (long)off * 2L;
        long bytesLen = (long)len * 2L;
        long left = this.remaining();
        if (left < bytesLen) {
            throw new IllegalStateException(new EOFException());
        }
        this.getChronicleUnsafe().copyMemory(null, this.position, data, (long)BYTES_OFFSET + bytesOff, bytesLen);
        this.addPosition(bytesLen);
    }

    @Override
    public short readShort() {
        short s = this.getChronicleUnsafe().getShort(this.position);
        this.addPosition(2L);
        return s;
    }

    @Override
    public short readShort(long offset) {
        return this.getChronicleUnsafe().getShort(this.start + offset);
    }

    @Override
    public char readChar() {
        char ch = this.getChronicleUnsafe().getChar(this.position);
        this.addPosition(2L);
        return ch;
    }

    @Override
    public char readChar(long offset) {
        return this.getChronicleUnsafe().getChar(this.start + offset);
    }

    @Override
    public int readInt() {
        int i = this.getChronicleUnsafe().getInt(this.position);
        this.addPosition(4L);
        return i;
    }

    @Override
    public int readInt(long offset) {
        return this.getChronicleUnsafe().getInt(this.start + offset);
    }

    @Override
    public int readVolatileInt() {
        int i = this.getChronicleUnsafe().getIntVolatile(null, this.position);
        this.addPosition(4L);
        return i;
    }

    @Override
    public int readVolatileInt(long offset) {
        return this.getChronicleUnsafe().getIntVolatile(null, this.start + offset);
    }

    @Override
    public long readLong() {
        long l = this.getChronicleUnsafe().getLong(this.position);
        this.addPosition(8L);
        return l;
    }

    @Override
    public long readLong(long offset) {
        return this.getChronicleUnsafe().getLong(this.start + offset);
    }

    @Override
    public long readVolatileLong() {
        long l = this.getChronicleUnsafe().getLongVolatile(null, this.position);
        this.addPosition(8L);
        return l;
    }

    @Override
    public long readVolatileLong(long offset) {
        return this.getChronicleUnsafe().getLongVolatile(null, this.start + offset);
    }

    @Override
    public float readFloat() {
        float f = this.getChronicleUnsafe().getFloat(this.position);
        this.addPosition(4L);
        return f;
    }

    @Override
    public float readFloat(long offset) {
        return this.getChronicleUnsafe().getFloat(this.start + offset);
    }

    @Override
    public double readDouble() {
        double d = this.getChronicleUnsafe().getDouble(this.position);
        this.addPosition(8L);
        return d;
    }

    @Override
    public double readDouble(long offset) {
        return this.getChronicleUnsafe().getDouble(this.start + offset);
    }

    @Override
    public void write(int b) {
        this.getChronicleUnsafe().putByte(this.position, (byte)b);
        this.incrementPositionAddr(1L);
    }

    @Override
    public void writeByte(long offset, int b) {
        this.offsetChecks(offset, 1L);
        this.getChronicleUnsafe().putByte(this.start + offset, (byte)b);
    }

    @Override
    public void write(long offset, @NotNull byte[] bytes) {
        if (offset < 0L || offset + (long)bytes.length > this.capacity()) {
            throw new IllegalArgumentException();
        }
        this.getChronicleUnsafe().copyMemory(bytes, BYTES_OFFSET, null, this.start + offset, bytes.length);
        this.addPosition(bytes.length);
    }

    @Override
    public void write(byte[] bytes, int off, int len) {
        if (off < 0 || off + len > bytes.length || (long)len > this.remaining()) {
            throw new IllegalArgumentException();
        }
        this.getChronicleUnsafe().copyMemory(bytes, BYTES_OFFSET + off, null, this.position, len);
        this.addPosition(len);
    }

    @Override
    public void write(long offset, byte[] bytes, int off, int len) {
        if (offset < 0L || off + len > bytes.length || offset + (long)len > this.capacity()) {
            throw new IllegalArgumentException();
        }
        this.getChronicleUnsafe().copyMemory(bytes, BYTES_OFFSET + off, null, this.start + offset, len);
    }

    @Override
    public void writeShort(int v) {
        this.positionChecks(this.position + 2L);
        this.getChronicleUnsafe().putShort(this.position, (short)v);
        this.position += 2L;
    }

    private long incrementPositionAddr(long value) {
        this.positionAddr(this.positionAddr() + value);
        return this.positionAddr();
    }

    @Override
    public void writeShort(long offset, int v) {
        this.offsetChecks(offset, 2L);
        this.getChronicleUnsafe().putShort(this.start + offset, (short)v);
    }

    @Override
    public void writeChar(int v) {
        this.positionChecks(this.position + 2L);
        this.getChronicleUnsafe().putChar(this.position, (char)v);
        this.position += 2L;
    }

    void addPosition(long delta) {
        this.positionAddr(this.positionAddr() + delta);
    }

    @Override
    public void writeChar(long offset, int v) {
        this.offsetChecks(offset, 2L);
        this.getChronicleUnsafe().putChar(this.start + offset, (char)v);
    }

    @Override
    public void writeInt(int v) {
        this.positionChecks(this.position + 4L);
        this.getChronicleUnsafe().putInt(this.position, v);
        this.position += 4L;
    }

    @Override
    public void writeInt(long offset, int v) {
        this.offsetChecks(offset, 4L);
        this.getChronicleUnsafe().putInt(this.start + offset, v);
    }

    @Override
    public void writeOrderedInt(int v) {
        this.positionChecks(this.position + 4L);
        this.getChronicleUnsafe().putOrderedInt(null, this.position, v);
        this.position += 4L;
    }

    @Override
    public void writeOrderedInt(long offset, int v) {
        this.offsetChecks(offset, 4L);
        this.getChronicleUnsafe().putOrderedInt(null, this.start + offset, v);
    }

    @Override
    public boolean compareAndSwapInt(long offset, int expected, int x) {
        this.offsetChecks(offset, 4L);
        return this.getChronicleUnsafe().compareAndSwapInt(null, this.start + offset, expected, x);
    }

    @Override
    public void writeLong(long v) {
        this.positionChecks(this.position + 8L);
        this.getChronicleUnsafe().putLong(this.position, v);
        this.position += 8L;
    }

    @Override
    public void writeLong(long offset, long v) {
        this.offsetChecks(offset, 8L);
        this.getChronicleUnsafe().putLong(this.start + offset, v);
    }

    @Override
    public void writeOrderedLong(long v) {
        this.positionChecks(this.position + 8L);
        this.getChronicleUnsafe().putOrderedLong(null, this.position, v);
        this.position += 8L;
    }

    @Override
    public void writeOrderedLong(long offset, long v) {
        this.offsetChecks(offset, 8L);
        this.getChronicleUnsafe().putOrderedLong(null, this.start + offset, v);
    }

    @Override
    public boolean compareAndSwapLong(long offset, long expected, long x) {
        this.offsetChecks(offset, 8L);
        return this.getChronicleUnsafe().compareAndSwapLong(null, this.start + offset, expected, x);
    }

    @Override
    public void writeFloat(float v) {
        this.positionChecks(this.position + 4L);
        this.getChronicleUnsafe().putFloat(this.position, v);
        this.position += 4L;
    }

    @Override
    public void writeFloat(long offset, float v) {
        this.offsetChecks(offset, 4L);
        this.getChronicleUnsafe().putFloat(this.start + offset, v);
    }

    @Override
    public void writeDouble(double v) {
        this.positionChecks(this.position + 8L);
        this.getChronicleUnsafe().putDouble(this.position, v);
        this.position += 8L;
    }

    @Override
    public void writeDouble(long offset, double v) {
        this.offsetChecks(offset, 8L);
        this.getChronicleUnsafe().putDouble(this.start + offset, v);
    }

    @Override
    public void readObject(Object object, int start, int end) {
        int len = end - start;
        if (this.position + (long)len >= this.limit) {
            throw new IndexOutOfBoundsException("Length out of bounds len: " + len);
        }
        ChronicleUnsafe unsafe = this.getChronicleUnsafe();
        while (len >= 8) {
            unsafe.putLong(object, start, unsafe.getLong(this.position));
            this.incrementPositionAddr(8L);
            start += 8;
            len -= 8;
        }
        while (len > 0) {
            unsafe.putByte(object, start, unsafe.getByte(this.position));
            this.incrementPositionAddr(1L);
            ++start;
            --len;
        }
    }

    @Override
    public void writeObject(Object object, int start, int end) {
        int len;
        ChronicleUnsafe unsafe = this.getChronicleUnsafe();
        for (len = end - start; len >= 8; len -= 8) {
            this.positionChecks(this.position + 8L);
            unsafe.putLong(this.position, unsafe.getLong(object, (long)start));
            this.position += 8L;
            start += 8;
        }
        while (len > 0) {
            this.positionChecks(this.position + 1L);
            unsafe.putByte(this.position, unsafe.getByte(object, start));
            ++this.position;
            ++start;
            --len;
        }
    }

    @Override
    public boolean compare(long offset, RandomDataInput input, long inputOffset, long len) {
        long i;
        if (offset < 0L || inputOffset < 0L || len < 0L) {
            throw new IndexOutOfBoundsException();
        }
        if (offset + len < 0L || offset + len > this.capacity() || inputOffset + len < 0L || inputOffset + len > input.capacity()) {
            return false;
        }
        ChronicleUnsafe unsafe = this.getChronicleUnsafe();
        for (i = 0L; i < len - 7L; i += 8L) {
            if (unsafe.getLong(this.start + offset + i) == input.readLong(inputOffset + i)) continue;
            return false;
        }
        if (i < len - 3L) {
            if (unsafe.getInt(this.start + offset + i) != input.readInt(inputOffset + i)) {
                return false;
            }
            i += 4L;
        }
        if (i < len - 1L) {
            if (unsafe.getChar(this.start + offset + i) != input.readChar(inputOffset + i)) {
                return false;
            }
            i += 2L;
        }
        return i >= len || unsafe.getByte(this.start + offset + i) == input.readByte(inputOffset + i);
    }

    @Override
    public long position() {
        return this.position - this.start;
    }

    @Override
    public MappedNativeBytes position(long position) {
        if (position < 0L || position > this.limit()) {
            throw new IndexOutOfBoundsException("position: " + position + " limit: " + this.limit());
        }
        this.positionAddr(this.start + position);
        return this;
    }

    public MappedNativeBytes lazyPosition(long position) {
        if (position < 0L || position > this.limit()) {
            throw new IndexOutOfBoundsException("position: " + position + " limit: " + this.limit());
        }
        this.positionAddr(this.start + position);
        return this;
    }

    @Override
    public void write(RandomDataInput bytes, long position, long length) {
        if (length > this.remaining()) {
            throw new IllegalArgumentException("Attempt to write " + length + " bytes with " + this.remaining() + " remaining");
        }
        if (bytes instanceof MappedNativeBytes) {
            this.getChronicleUnsafe().copyMemory(((MappedNativeBytes)bytes).start + position, this.position, length);
            this.skip(length);
        } else {
            super.write(bytes, position, length);
        }
    }

    @Override
    public long capacity() {
        return this.capacity - this.start;
    }

    @Override
    public long remaining() {
        return this.limit - this.position;
    }

    @Override
    public long limit() {
        return this.limit - this.start;
    }

    @Override
    public MappedNativeBytes limit(long limit) {
        if (limit < 0L || limit > this.capacity()) {
            throw new IllegalArgumentException("limit: " + limit + " capacity: " + this.capacity());
        }
        this.limit = this.start + limit;
        return this;
    }

    @Override
    @NotNull
    public ByteOrder byteOrder() {
        return ByteOrder.nativeOrder();
    }

    @Override
    public void checkEndOfBuffer() throws IndexOutOfBoundsException {
        if (this.position() > this.limit()) {
            throw new IndexOutOfBoundsException("position is beyond the end of the buffer " + this.position() + " > " + this.limit());
        }
    }

    public long startAddr() {
        return this.start;
    }

    long capacityAddr() {
        return this.capacity;
    }

    @Override
    protected void cleanup() {
    }

    @Override
    public Bytes load() {
        ChronicleUnsafe unsafe = this.getChronicleUnsafe();
        int pageSize = unsafe.pageSize();
        for (long addr = this.start; addr < this.capacity; addr += (long)pageSize) {
            unsafe.getByte(addr);
        }
        return this;
    }

    @Override
    public void alignPositionAddr(int powerOf2) {
        long value = this.position + (long)powerOf2 - 1L & (long)(~(powerOf2 - 1));
        this.positionAddr(value);
    }

    public void positionAddr(long positionAddr) {
        this.positionChecks(positionAddr);
        this.position = positionAddr;
    }

    void positionChecks(long positionAddr) {
        assert (this.actualPositionChecks(positionAddr));
    }

    boolean actualPositionChecks(long positionAddr) {
        if (positionAddr < this.start) {
            throw new IndexOutOfBoundsException("position before the start by " + (this.start - positionAddr) + " bytes");
        }
        if (positionAddr > this.limit) {
            throw new IndexOutOfBoundsException("position after the limit by " + (positionAddr - this.limit) + " bytes");
        }
        return true;
    }

    void offsetChecks(long offset, long len) {
        assert (this.actualOffsetChecks(offset, len));
    }

    boolean actualOffsetChecks(long offset, long len) {
        if (offset < 0L || offset + len > this.capacity()) {
            throw new IndexOutOfBoundsException("offset out of bounds: " + offset + ", len: " + len + ", capacity: " + this.capacity());
        }
        return true;
    }

    public long positionAddr() {
        return this.position;
    }

    @Override
    public ByteBuffer sliceAsByteBuffer(ByteBuffer toReuse) {
        return this.sliceAsByteBuffer(toReuse, null);
    }

    protected ByteBuffer sliceAsByteBuffer(ByteBuffer toReuse, Object att) {
        return ByteBufferReuse.INSTANCE.reuse(this.position, (int)this.remaining(), att, toReuse);
    }

    @NotNull
    public ChronicleUnsafe getChronicleUnsafe() {
        if (this.isSingleThreaded) {
            return this.chronicleUnsafe;
        }
        ChronicleUnsafe chronicleUnsafe = this.threadLocal.get();
        if (chronicleUnsafe == null) {
            chronicleUnsafe = new ChronicleUnsafe(this.mappedFile);
            this.threadLocal.set(chronicleUnsafe);
        }
        return chronicleUnsafe;
    }

    static {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            Unsafe unsafe = (Unsafe)theUnsafe.get(null);
            BYTES_OFFSET = unsafe.arrayBaseOffset(byte[].class);
            CHARS_OFFSET = unsafe.arrayBaseOffset(char[].class);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }
}

