/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.plugin.drmemory;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.DataSetBuilder;
import hudson.util.ShiftedCategoryAxis;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import net.praqma.drmemory.DrMemoryResult;
import net.praqma.jenkins.plugin.drmemory.DrMemoryBuilder;
import net.praqma.jenkins.plugin.drmemory.DrMemoryPublisher;
import net.praqma.jenkins.plugin.drmemory.graphs.AbstractGraph;
import org.apache.commons.io.FileUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class DrMemoryBuildAction
implements Action {
    private static final Logger logger = Logger.getLogger(DrMemoryBuildAction.class.getName());
    private final AbstractBuild<?, ?> build;
    private List<DrMemoryPublisher> publishers;
    private List<DrMemoryBuilder> builders;
    private List<DrMemoryResult> results;

    protected DrMemoryBuildAction(AbstractBuild<?, ?> build) {
        this.build = build;
        this.builders = new ArrayList<DrMemoryBuilder>();
        this.results = new ArrayList<DrMemoryResult>();
        this.publishers = new ArrayList<DrMemoryPublisher>();
    }

    public void addPublisher(DrMemoryPublisher publisher) {
        this.publishers.add(publisher);
    }

    public void addBuilder(DrMemoryBuilder builder) {
        this.builders.add(builder);
    }

    public List<DrMemoryPublisher> getPublishers() {
        return this.publishers;
    }

    public void addResult(DrMemoryResult result) {
        this.results.add(result);
    }

    public List<DrMemoryBuilder> getBuilders() {
        return this.builders;
    }

    public String getDisplayName() {
        return "DrMemory";
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getUrlName() {
        return "drmemory";
    }

    public List<DrMemoryResult> getResults() {
        return this.results;
    }

    public static DrMemoryBuildAction getActionForBuild(AbstractBuild<?, ?> build) {
        DrMemoryBuildAction action = (DrMemoryBuildAction)build.getAction(DrMemoryBuildAction.class);
        if (action == null) {
            action = new DrMemoryBuildAction(build);
            build.addAction((Action)action);
        }
        return action;
    }

    public void doIndex(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        File dm = new File(this.build.getRootDir(), "drmemory.txt");
        Calendar t = this.build.getTimestamp();
        if (dm.exists()) {
            rsp.serveFile(req, (InputStream)FileUtils.openInputStream((File)dm), t.getTimeInMillis(), dm.getTotalSpace(), "drmemory.txt");
        } else {
            rsp.sendError(204);
        }
    }

    static DrMemoryBuildAction getPreviousResult(AbstractBuild<?, ?> start) {
        AbstractBuild b = start;
        while ((b = (AbstractBuild)b.getPreviousBuild()) != null) {
            DrMemoryBuildAction r = (DrMemoryBuildAction)b.getAction(DrMemoryBuildAction.class);
            if (r == null || r.getResults() == null || r.getResults().isEmpty()) continue;
            return r;
        }
        return null;
    }

    public DrMemoryBuildAction getPreviousResult() {
        return DrMemoryBuildAction.getPreviousResult(this.build);
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        String type = req.getParameter("type");
        logger.fine("Graphing " + type);
        int width = 500;
        int height = 200;
        String w = req.getParameter("width");
        String h = req.getParameter("height");
        if (w != null && w.length() > 0) {
            width = Integer.parseInt(w);
        }
        if (h != null && h.length() > 0) {
            height = Integer.parseInt(h);
        }
        if (type == null) {
            throw new IOException("No type given");
        }
        if (ChartUtil.awtProblemCause != null) {
            rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
            return;
        }
        Calendar t = this.build.getTimestamp();
        if (req.checkIfModified(t, rsp)) {
            return;
        }
        DataSetBuilder dsb = new DataSetBuilder();
        boolean latest = true;
        String yaxis = "???";
        float min = Float.MAX_VALUE;
        float max = 0.0f;
        AbstractGraph g = DrMemoryPublisher.getGraphTypes().get(type);
        if (g == null) {
            rsp.sendError(1);
            return;
        }
        for (DrMemoryBuildAction a = this; a != null; a = a.getPreviousResult()) {
            logger.finest("Build " + a.getDisplayName());
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(a.build);
            if (a.getResults().size() == 0) {
                return;
            }
            int fields = g.getNumber(a.getResults().get(0)).length;
            float[] sums = new float[fields];
            for (int i = 0; i < fields; ++i) {
                sums[i] = 0.0f;
            }
            for (DrMemoryResult result : a.getResults()) {
                float[] ns = g.getNumber(result);
                for (int i = 0; i < ns.length; ++i) {
                    int n = i;
                    sums[n] = sums[n] + ns[i];
                }
            }
            g.addX((DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel>)dsb, sums, label);
            for (float n : sums) {
                if (n > max) {
                    max = n;
                }
                if (!(n < min)) continue;
                min = n;
            }
            if (latest) {
                yaxis = g.getYAxis();
            }
            latest = false;
        }
        ChartUtil.generateGraph((StaplerRequest)req, (StaplerResponse)rsp, (JFreeChart)this.createChart(dsb.build(), g.getTitle(), yaxis, (int)max, (int)min), (int)width, (int)height);
    }

    private JFreeChart createChart(CategoryDataset dataset, String title, String yaxis, int max, int min) {
        JFreeChart chart = ChartFactory.createLineChart((String)title, null, (String)yaxis, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        LegendTitle legend = chart.getLegend();
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setUpperBound((double)max);
        rangeAxis.setLowerBound((double)min);
        LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
        renderer.setBaseStroke((Stroke)new BasicStroke(2.0f));
        ColorPalette.apply((LineAndShapeRenderer)renderer);
        plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
        return chart;
    }

    public static enum GraphType {
        TOTAL_LEAK;

    }
}

