/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.plugin.drmemory;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Actionable;
import hudson.model.ProminentProjectAction;
import hudson.model.Result;
import java.io.IOException;
import java.util.logging.Logger;
import net.praqma.jenkins.plugin.drmemory.DrMemoryBuildAction;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class DrMemoryProjectAction
extends Actionable
implements ProminentProjectAction {
    private final AbstractProject<?, ?> project;
    private static final Logger log = Logger.getLogger(DrMemoryProjectAction.class.toString());

    public DrMemoryProjectAction(AbstractProject<?, ?> project) {
        this.project = project;
    }

    public String getDisplayName() {
        return "DrMemory";
    }

    public String getSearchUrl() {
        return this.getUrlName();
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getUrlName() {
        return "drmemory";
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (this.getLastResult() != null) {
            this.getLastResult().doGraph(req, rsp);
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public DrMemoryBuildAction getLastResult() {
        for (AbstractBuild b = this.getLastBuildToBeConsidered(); b != null; b = (AbstractBuild)b.getPreviousNotFailedBuild()) {
            if (!b.getResult().isBetterOrEqualTo(Result.UNSTABLE)) continue;
            log.fine(String.format("Using build %s to draw graph", b.number));
            DrMemoryBuildAction r = (DrMemoryBuildAction)b.getAction(DrMemoryBuildAction.class);
            if (r == null) continue;
            return r;
        }
        log.fine(String.format("Found no results to draw graphs with", new Object[0]));
        return null;
    }

    private AbstractBuild<?, ?> getLastBuildToBeConsidered() {
        return (AbstractBuild)this.project.getLastSuccessfulBuild();
    }
}

