/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.plugin.drmemory;

import hudson.FilePath;
import hudson.model.BuildListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import net.praqma.drmemory.DrMemory;
import org.jenkinsci.remoting.RoleChecker;

public class DrMemoryRemoteBuilder
implements FilePath.FileCallable<Boolean> {
    private String executable;
    private String arguments;
    private String logPath;
    private BuildListener listener;

    public DrMemoryRemoteBuilder(String executable, String arguments, String logPath, BuildListener listener) {
        this.executable = executable;
        this.arguments = arguments;
        this.logPath = logPath;
        this.listener = listener;
    }

    public Boolean invoke(File workspace, VirtualChannel channel) throws IOException, InterruptedException {
        PrintStream out = this.listener.getLogger();
        File executable = new File(workspace, this.executable);
        out.println("Executing " + executable + " " + this.arguments);
        DrMemory dm = new DrMemory(executable, this.arguments);
        dm.setWorkDir(workspace);
        File logpath = new File(workspace, this.logPath);
        boolean createdDirs = logpath.mkdirs();
        if (createdDirs) {
            out.println("Created logdir: " + logpath);
        }
        out.println("Setting log path to " + logpath);
        dm.setLogDir(logpath);
        try {
            dm.start();
        }
        catch (Exception e) {
            throw new IOException(String.format("Dr. Memory retuned with a non-zero exit code. Message was:%n%s", e.getMessage()));
        }
        return true;
    }

    public void checkRoles(RoleChecker roleChecker) throws SecurityException {
    }
}

