/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.plugin.monkit;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.HealthReport;
import hudson.model.HealthReportingAction;
import hudson.model.Result;
import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.DataSetBuilder;
import hudson.util.ShiftedCategoryAxis;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import net.praqma.jenkins.plugin.monkit.MonKitPublisher;
import net.praqma.jenkins.plugin.monkit.MonKitTarget;
import net.praqma.monkit.MonKitCategory;
import net.praqma.monkit.MonKitObservation;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonKitBuildAction
implements HealthReportingAction,
Action {
    private List<MonKitCategory> monkit;
    private final AbstractBuild<?, ?> build;
    private boolean onlyStable;
    private MonKitPublisher publisher;

    public MonKitBuildAction(AbstractBuild<?, ?> build, List<MonKitCategory> monkit) {
        this.monkit = monkit;
        this.build = build;
        this.onlyStable = false;
    }

    public void setPublisher(MonKitPublisher publisher) {
        this.publisher = publisher;
    }

    public String getDisplayName() {
        return "MonKit";
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getUrlName() {
        return "monkit";
    }

    public HealthReport getBuildHealth() {
        MonKitPublisher.Case worst = this.publisher.getWorst(this.monkit);
        if (worst.health == null) {
            return new HealthReport(0, "MonKit Report: " + worst.category + " for " + worst.name);
        }
        if (worst.category == null) {
            return new HealthReport(100, "MonKit Report");
        }
        return new HealthReport(worst.health.intValue(), "MonKit Report: " + worst.category + " for " + worst.name);
    }

    public HealthReport getBuildHealth1() {
        Integer health = 1;
        float worst = 100.0f;
        String worstStr = "Unknown";
        boolean healthy = true;
        for (MonKitTarget mkt : this.publisher.getTargets()) {
            for (MonKitCategory mkc : this.monkit) {
                if (!mkt.getCategory().equalsIgnoreCase(mkc.getName())) continue;
                for (MonKitObservation mko : mkc) {
                    boolean isGreater;
                    Float f = new Float(mko.getValue());
                    Float fu = new Float(mkt.getUnstable().intValue());
                    Float fh = new Float(mkt.getHealthy().intValue());
                    boolean bl = isGreater = fu.floatValue() < fh.floatValue();
                    if (isGreater && f.floatValue() < fu.floatValue() || !isGreater && f.floatValue() > fu.floatValue()) {
                        return new HealthReport(0, "MonKit Report: " + mkc.getName() + " for " + mko.getName());
                    }
                    if (!(isGreater && f.floatValue() < fh.floatValue()) && (isGreater || !(f.floatValue() > fh.floatValue()))) continue;
                    float diff = fh.floatValue() - fu.floatValue();
                    float nf1 = f.floatValue() - fu.floatValue();
                    float inter = nf1 / diff * 100.0f;
                    if (inter < worst) {
                        worst = inter;
                        worstStr = mkc.getName() + " for " + mko.getName();
                    }
                    healthy = false;
                }
            }
        }
        if (healthy) {
            return new HealthReport(100, "MonKit Report");
        }
        return new HealthReport((int)worst, "MonKit Report: " + worstStr);
    }

    public List<String> getCategories() {
        ArrayList<String> categories = new ArrayList<String>();
        for (MonKitCategory mkc : this.monkit) {
            categories.add(mkc.getName());
        }
        return categories;
    }

    public List<MonKitCategory> getMonKitCategories() {
        return this.monkit;
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    public MonKitBuildAction getPreviousResult() {
        return MonKitBuildAction.getPreviousResult(this.build);
    }

    private boolean includeOnlyStable() {
        return this.onlyStable;
    }

    static MonKitBuildAction getPreviousResult(AbstractBuild<?, ?> start) {
        MonKitBuildAction r;
        AbstractBuild b = start;
        do {
            if ((b = (AbstractBuild)b.getPreviousNotFailedBuild()) == null) {
                return null;
            }
            assert (b.getResult() != Result.FAILURE) : "We asked for the previous not failed build";
            r = (MonKitBuildAction)b.getAction(MonKitBuildAction.class);
            if (r == null || !r.includeOnlyStable() || b.getResult() == Result.SUCCESS) continue;
            r = null;
        } while (r == null);
        return r;
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        String category = req.getParameter("category");
        if (category == null) {
            throw new IOException("No type given");
        }
        if (ChartUtil.awtProblemCause != null) {
            rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
            return;
        }
        Calendar t = this.build.getTimestamp();
        if (req.checkIfModified(t, rsp)) {
            return;
        }
        DataSetBuilder dsb = new DataSetBuilder();
        int min = 1000000;
        int max = -110001100;
        String scale = "Unknown";
        for (MonKitBuildAction a = this; a != null; a = a.getPreviousResult()) {
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(a.build);
            for (MonKitCategory mkc : a.getMonKitCategories()) {
                if (!mkc.getName().equalsIgnoreCase(category)) continue;
                for (MonKitObservation mko : mkc) {
                    Float f = new Float(mko.getValue());
                    dsb.add((Number)f, (Comparable)((Object)mko.getName()), (Comparable)label);
                    if (f.intValue() > max) {
                        max = f.intValue() + 1;
                    }
                    if (f.intValue() < min && (min = f.intValue()) != 0) {
                        --min;
                    }
                    scale = mkc.getScale();
                }
            }
        }
        ChartUtil.generateGraph((StaplerRequest)req, (StaplerResponse)rsp, (JFreeChart)this.createChart(dsb.build(), category, scale, max, min), (int)500, (int)200);
    }

    private JFreeChart createChart(CategoryDataset dataset, String title, String yaxis, int max, int min) {
        JFreeChart chart = ChartFactory.createLineChart((String)title, null, (String)yaxis, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.RIGHT);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setUpperBound((double)max);
        rangeAxis.setLowerBound((double)min);
        LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
        renderer.setBaseStroke((Stroke)new BasicStroke(2.0f));
        ColorPalette.apply((LineAndShapeRenderer)renderer);
        plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
        return chart;
    }
}

