/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.plugin.monkit;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.praqma.jenkins.plugin.monkit.MonKitBuildAction;
import net.praqma.jenkins.plugin.monkit.MonKitProjectAction;
import net.praqma.jenkins.plugin.monkit.MonKitTarget;
import net.praqma.monkit.MonKit;
import net.praqma.monkit.MonKitCategory;
import net.praqma.monkit.MonKitException;
import net.praqma.monkit.MonKitObservation;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonKitPublisher
extends Recorder {
    private String monKitFile = "monkit.xml";
    public static final MonKitFilenameFilter __MONKIT_FILENAME_FILTER = new MonKitFilenameFilter();
    private boolean onlyStable;
    private List<MonKitTarget> targets;

    @DataBoundConstructor
    public MonKitPublisher(String monKitFile, boolean onlyStable) {
        this.monKitFile = monKitFile;
        this.onlyStable = onlyStable;
        this.targets = new ArrayList<MonKitTarget>();
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        FilePath[] moduleRoots = build.getModuleRoots();
        boolean multipleModuleRoots = moduleRoots != null && moduleRoots.length > 1;
        FilePath moduleRoot = multipleModuleRoots ? build.getWorkspace() : build.getModuleRoot();
        FilePath[] reports = new FilePath[]{};
        try {
            reports = moduleRoot.list(this.monKitFile);
            if (build.getResult().isWorseOrEqualTo(Result.FAILURE) && reports.length == 0) {
                return true;
            }
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError("Unable to find MonKit files"));
            build.setResult(Result.FAILURE);
        }
        ArrayList<MonKit> mks = new ArrayList<MonKit>();
        for (int i = 0; i < reports.length; ++i) {
            try {
                MonKit mke = MonKit.fromString((String)reports[i].readToString());
                mks.add(mke);
                continue;
            }
            catch (MonKitException e) {
                e.printStackTrace(listener.fatalError("Unable to get " + reports[i].getName() + ". Skipping"));
            }
        }
        MonKit mk = MonKit.merge(mks);
        MonKitBuildAction mka = new MonKitBuildAction(build, mk.getCategories());
        mka.setPublisher(this);
        build.getActions().add(mka);
        Case worst = this.getWorst(mk.getCategories());
        if (worst.health == null) {
            build.setResult(Result.UNSTABLE);
        }
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean getOnlyStable() {
        return this.onlyStable;
    }

    public String getMonKitFile() {
        return this.monKitFile;
    }

    public boolean isOnlyStable() {
        return this.onlyStable;
    }

    public List<MonKitTarget> getTargets() {
        return this.targets;
    }

    private void setTargets(List<MonKitTarget> targets) {
        this.targets.clear();
        this.targets = targets;
    }

    public Case getWorst(List<MonKitCategory> monkit) {
        boolean healthy = true;
        Case worst = new Case();
        for (MonKitTarget mkt : this.getTargets()) {
            for (MonKitCategory mkc : monkit) {
                if (!mkt.getCategory().equalsIgnoreCase(mkc.getName())) continue;
                for (MonKitObservation mko : mkc) {
                    Float f = new Float(mko.getValue());
                    Float fu = new Float(mkt.getUnstable().intValue());
                    Float fh = new Float(mkt.getHealthy().intValue());
                    boolean isGreater = fu.floatValue() < fh.floatValue();
                    System.out.println("F=" + f + ". FU=" + fu + ". FH=" + fh + ". ISGREATER=" + isGreater);
                    if (isGreater && f.floatValue() < fu.floatValue() || !isGreater && f.floatValue() > fu.floatValue()) {
                        return new Case(null, mkc.getName(), mko.getName());
                    }
                    System.out.println("F3=" + fh);
                    if (!(isGreater && f.floatValue() < fh.floatValue()) && (isGreater || !(f.floatValue() > fh.floatValue()))) continue;
                    float diff = fh.floatValue() - fu.floatValue();
                    float nf1 = f.floatValue() - fu.floatValue();
                    float inter = nf1 / diff * 100.0f;
                    System.out.println("DIFF=" + diff + ". NF1=" + nf1 + ". INTER=" + inter);
                    System.out.println("INTER=" + inter);
                    if (inter < worst.health.floatValue()) {
                        worst.health = Float.valueOf(inter);
                        worst.category = mkc.getName();
                        worst.name = mko.getName();
                    }
                    healthy = false;
                }
            }
        }
        if (healthy) {
            return new Case(Float.valueOf(100.0f), null, null);
        }
        return worst;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new MonKitProjectAction(project, this.getOnlyStable());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return "MonKit Report";
        }

        public boolean isApplicable(Class<? extends AbstractProject> arg0) {
            return true;
        }

        public MonKitPublisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            MonKitPublisher instance = (MonKitPublisher)((Object)req.bindJSON(MonKitPublisher.class, formData));
            List targets = req.bindParametersToList(MonKitTarget.class, "monkit.target.");
            instance.setTargets(targets);
            return instance;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            req.bindParameters((Object)this, "monkit.");
            this.save();
            return super.configure(req, formData);
        }

        public List<MonKitTarget> getDefaultTargets() {
            ArrayList<MonKitTarget> result = new ArrayList<MonKitTarget>();
            return result;
        }

        public List<MonKitTarget> getTargets(MonKitPublisher instance) {
            if (instance == null) {
                return this.getDefaultTargets();
            }
            return instance.getTargets();
        }
    }

    public class Case {
        Float health = Float.valueOf(100.0f);
        String category = "";
        String name = "";

        public Case() {
        }

        public Case(Float health, String category, String name) {
            this.health = health;
            this.category = category;
            this.name = name;
        }
    }

    private static class MonKitFilenameFilter
    implements FilenameFilter {
        private MonKitFilenameFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.matches("^monkit.*\\.xml$");
        }
    }
}

