/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.plugin.monkit;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Actionable;
import hudson.model.ProminentProjectAction;
import hudson.model.Result;
import java.io.IOException;
import net.praqma.jenkins.plugin.monkit.MonKitBuildAction;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonKitProjectAction
extends Actionable
implements ProminentProjectAction {
    private final AbstractProject<?, ?> project;
    private boolean onlyStable;

    public MonKitProjectAction(AbstractProject<?, ?> project, boolean onlyStable) {
        this.project = project;
        this.onlyStable = onlyStable;
    }

    public String getDisplayName() {
        return "MonKit";
    }

    public String getSearchUrl() {
        return this.getUrlName();
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getUrlName() {
        return "monkit";
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (this.getLastResult() != null) {
            this.getLastResult().doGraph(req, rsp);
        }
    }

    public void doSnade(StaplerRequest req, StaplerResponse rsp) throws IOException {
        rsp.getOutputStream().println("Hej, mand!");
    }

    public MonKitBuildAction getLastResult() {
        for (AbstractBuild b = this.getLastBuildToBeConsidered(); b != null; b = (AbstractBuild)b.getPreviousNotFailedBuild()) {
            MonKitBuildAction r;
            if (b.getResult() == Result.FAILURE || b.getResult() != Result.SUCCESS && this.onlyStable || (r = (MonKitBuildAction)b.getAction(MonKitBuildAction.class)) == null) continue;
            return r;
        }
        return null;
    }

    private AbstractBuild<?, ?> getLastBuildToBeConsidered() {
        return this.onlyStable ? (AbstractBuild)this.project.getLastStableBuild() : (AbstractBuild)this.project.getLastSuccessfulBuild();
    }
}

