/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.plugin.prqa;

import hudson.FilePath;
import hudson.model.BuildListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.praqma.prqa.PRQAApplicationSettings;
import net.praqma.prqa.PRQAReportSettings;
import net.praqma.prqa.exceptions.PrqaException;
import net.praqma.prqa.reports.PRQAReport;
import net.praqma.prqa.status.PRQAComplianceStatus;
import net.praqma.util.execute.CmdResult;
import org.apache.commons.lang.StringUtils;

public class PRQARemoteReport
implements FilePath.FileCallable<PRQAComplianceStatus> {
    private PRQAReport report;
    private BuildListener listener;
    boolean isUnix;

    public PRQARemoteReport(PRQAReport report, BuildListener listener, boolean isUnix) {
        this.report = report;
        this.listener = listener;
        this.isUnix = isUnix;
    }

    private HashMap<String, String> expandEnvironment(HashMap<String, String> environment, PRQAApplicationSettings appSettings, PRQAReportSettings reportSetting) {
        String pathVar = "path";
        Map<String, String> localEnv = System.getenv();
        for (String s : localEnv.keySet()) {
            if (!s.equalsIgnoreCase(pathVar)) continue;
            pathVar = s;
            break;
        }
        String currentPath = localEnv.get(pathVar);
        String delimiter = System.getProperty("file.separator");
        String pathSep = System.getProperty("path.separator");
        if (environment != null) {
            if (reportSetting.product.equalsIgnoreCase("qac")) {
                String slashPath = PRQAApplicationSettings.addSlash((String)environment.get("QACPATH"), (String)delimiter);
                environment.put("QACPATH", slashPath);
                String qacBin = PRQAApplicationSettings.addSlash((String)environment.get("QACPATH"), (String)delimiter) + "bin";
                environment.put("QACBIN", qacBin);
                environment.put("QACHELPFILES", environment.get("QACPATH") + "help");
                currentPath = environment.get("QACBIN") + pathSep + currentPath;
                environment.put("QACTEMP", System.getProperty("java.io.tmpdir"));
            } else {
                String slashPath = PRQAApplicationSettings.addSlash((String)environment.get("QACPPPATH"), (String)delimiter);
                environment.put("QACPPPATH", slashPath);
                String qacppBin = PRQAApplicationSettings.addSlash((String)environment.get("QACPPPATH"), (String)delimiter) + "bin";
                environment.put("QACPPBIN", qacppBin);
                environment.put("QACPPHELPFILES", environment.get("QACPPPATH") + "help");
                currentPath = environment.get("QACPPBIN") + pathSep + currentPath;
                environment.put("QACPPTEMP", System.getProperty("java.io.tmpdir"));
            }
            currentPath = PRQAApplicationSettings.addSlash((String)appSettings.qarHome, (String)delimiter) + "bin" + pathSep + currentPath;
            currentPath = this.isUnix ? PRQAApplicationSettings.addSlash((String)appSettings.qavClientHome, (String)delimiter) + "bin" + pathSep + currentPath : appSettings.qavClientHome + pathSep + currentPath;
            currentPath = PRQAApplicationSettings.addSlash((String)appSettings.qawHome, (String)delimiter) + "bin" + pathSep + currentPath;
            environment.put(pathVar, currentPath);
        }
        return environment;
    }

    public PRQAComplianceStatus invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
        try {
            HashMap<String, String> expandedEnvironment = this.expandEnvironment(this.report.getEnvironment(), this.report.getAppSettings(), this.report.getSettings());
            this.report.setEnvironment(expandedEnvironment);
            this.report.setWorkspace(f);
            if (!StringUtils.isBlank((String)this.report.getSettings().projectFile)) {
                this.listener.getLogger().println("Analysis command:");
                this.listener.getLogger().println(this.report.createAnalysisCommand(this.isUnix));
                this.report.analyze(this.isUnix);
            }
            this.listener.getLogger().println("Report command:");
            this.listener.getLogger().println(this.report.createReportCommand(this.isUnix));
            this.report.report(this.isUnix);
            if (!StringUtils.isBlank((String)this.report.createUploadCommand())) {
                this.listener.getLogger().println("Uploading with command:");
                this.listener.getLogger().println(this.report.createUploadCommand());
                CmdResult uploadResult = this.report.upload();
            }
            return this.report.getComplianceStatus();
        }
        catch (PrqaException exception) {
            throw new IOException(exception.getMessage(), exception);
        }
    }
}

