/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.plugin.prqa.globalconfig;

import java.io.Serializable;
import org.kohsuke.stapler.DataBoundConstructor;

public class QAVerifyServerConfiguration
implements Serializable {
    private String configurationName = "Configuration name";
    private String hostName;
    private Integer portNumber;
    private String userName;
    private String password;
    private String protocol;
    private Integer viewerPortNumber = 8080;

    @DataBoundConstructor
    public QAVerifyServerConfiguration(String configurationName, String hostName, Integer portNumber, String userName, String password, String protocol, Integer viewerPortNumber) {
        this.configurationName = configurationName;
        this.hostName = hostName;
        this.password = password;
        this.userName = userName;
        this.portNumber = portNumber;
        this.protocol = protocol;
        this.viewerPortNumber = viewerPortNumber;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public Integer getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(Integer portNumber) {
        this.portNumber = portNumber;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String toString() {
        return this.configurationName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof QAVerifyServerConfiguration) {
            if (this == obj) {
                return true;
            }
            QAVerifyServerConfiguration qavsc = (QAVerifyServerConfiguration)obj;
            return qavsc.getConfigurationName() != null && this.getConfigurationName() != null && qavsc.getConfigurationName().equals(this.getConfigurationName());
        }
        return false;
    }

    public String getFullUrl() {
        String full = this.protocol + "://" + this.hostName + ":" + this.viewerPortNumber;
        return full;
    }

    public Integer getViewerPortNumber() {
        return this.viewerPortNumber;
    }

    public void setViewerPortNumber(Integer viewerPortNumber) {
        this.viewerPortNumber = viewerPortNumber;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }
}

