/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.plugin.prqa.graphs;

import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import java.io.IOException;
import net.praqma.jenkins.plugin.prqa.graphs.PRQAGraph;
import net.praqma.prqa.PRQAContext;
import net.praqma.prqa.PRQAStatusCollection;
import net.praqma.prqa.exceptions.PrqaException;
import net.praqma.prqa.status.StatusCategory;
import org.jfree.chart.JFreeChart;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class ComplianceIndexGraphs
extends PRQAGraph {
    public ComplianceIndexGraphs() {
        super("Compliance Levels", PRQAContext.QARReportType.Compliance, StatusCategory.FileCompliance, StatusCategory.ProjectCompliance);
    }

    @Override
    public void setData(PRQAStatusCollection data) {
        this.data = data;
        this.data.overrideMax(StatusCategory.FileCompliance, (Number)100);
        this.data.overrideMin(StatusCategory.FileCompliance, (Number)0);
        this.data.overrideMax(StatusCategory.ProjectCompliance, (Number)100);
        this.data.overrideMin(StatusCategory.ProjectCompliance, (Number)0);
    }

    @Override
    public void drawGraph(StaplerRequest req, StaplerResponse rsp, DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel> dsb, Double tMax) throws IOException {
        Number max = null;
        Number min = null;
        int width = Integer.parseInt(req.getParameter("width"));
        int height = Integer.parseInt(req.getParameter("height"));
        for (StatusCategory category : this.categories) {
            try {
                max = this.data.getMax(category);
                min = this.data.getMin(category);
            }
            catch (PrqaException iex) {}
        }
        if (max != null && min != null) {
            ChartUtil.generateGraph((StaplerRequest)req, (StaplerResponse)rsp, (JFreeChart)this.createChart(dsb.build(), this.getTitle(), null, max.intValue(), min.intValue()), (int)width, (int)height);
        }
    }
}

