/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.plugin.prqa.notifier;

import hudson.Extension;
import hudson.util.FormValidation;
import net.praqma.jenkins.plugin.prqa.notifier.AbstractThreshold;
import net.praqma.jenkins.plugin.prqa.notifier.Messages;
import net.praqma.jenkins.plugin.prqa.notifier.ThresholdSelectionDescriptor;
import net.praqma.prqa.status.PRQAComplianceStatus;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class FileComplianceThreshold
extends AbstractThreshold {
    public final Double value;

    @DataBoundConstructor
    public FileComplianceThreshold(Double value, Boolean improvement) {
        super(improvement);
        this.value = value;
    }

    @Override
    public Boolean validateImprovement(PRQAComplianceStatus lastStableValue, PRQAComplianceStatus currentValue, int thresholdLevel) {
        if (lastStableValue == null) {
            return Boolean.TRUE;
        }
        return currentValue.getFileCompliance() >= lastStableValue.getFileCompliance();
    }

    @Override
    public String onUnstableMessage(PRQAComplianceStatus lastStableValue, PRQAComplianceStatus currentValue, int thresholdLevel) {
        if (!this.improvement.booleanValue()) {
            return Messages.PRQANotifier_FileComplianceRequirementNotMet(currentValue.getFileCompliance(), lastStableValue.getFileCompliance());
        }
        return Messages.PRQANotifier_FileComplianceRequirementNotMet(currentValue.getFileCompliance(), this.value);
    }

    @Override
    public Boolean validateThreshold(PRQAComplianceStatus currentValue, int thresholdLevel) {
        return currentValue.getFileCompliance() >= this.value;
    }

    @Extension
    public static final class DescriptorImpl
    extends ThresholdSelectionDescriptor<FileComplianceThreshold> {
        public String getDisplayName() {
            return "File Compliance Threshold";
        }

        public FormValidation doCheckValue(@QueryParameter String value) {
            try {
                Double parsedValue = Double.parseDouble(value);
                if (parsedValue < 0.0) {
                    return FormValidation.error((String)Messages.PRQANotifier_WrongDecimalValue());
                }
            }
            catch (NumberFormatException ex) {
                return FormValidation.error((String)Messages.PRQANotifier_WrongDecimalPunctuation());
            }
            return FormValidation.ok();
        }

        public String getHelpFile() {
            return "/plugin/prqa-plugin/config/help-thresholds.html";
        }
    }
}

