/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.plugin.prqa.notifier;

import hudson.Extension;
import hudson.util.FormValidation;
import java.util.logging.Logger;
import net.praqma.jenkins.plugin.prqa.notifier.AbstractThreshold;
import net.praqma.jenkins.plugin.prqa.notifier.Messages;
import net.praqma.jenkins.plugin.prqa.notifier.ThresholdSelectionDescriptor;
import net.praqma.prqa.status.PRQAComplianceStatus;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class MessageComplianceThreshold
extends AbstractThreshold {
    public final Integer value;
    private static final Logger log = Logger.getLogger(MessageComplianceThreshold.class.getName());

    @DataBoundConstructor
    public MessageComplianceThreshold(Integer value, int thresholdLevel, Boolean improvement) {
        super(improvement);
        this.value = value;
    }

    @Override
    public Boolean validateImprovement(PRQAComplianceStatus lastStableValue, PRQAComplianceStatus currentValue, int thresholdLevel) {
        if (lastStableValue == null) {
            return Boolean.TRUE;
        }
        return currentValue.getMessageCount(thresholdLevel) <= lastStableValue.getMessageCount(thresholdLevel);
    }

    @Override
    public String onUnstableMessage(PRQAComplianceStatus lastStableValue, PRQAComplianceStatus currentValue, int thresholdLevel) {
        if (this.improvement.booleanValue()) {
            return Messages.PRQANotifier_MaxMessagesRequirementNotMet(currentValue.getMessageCount(thresholdLevel), lastStableValue.getMessageCount(thresholdLevel));
        }
        return Messages.PRQANotifier_MaxMessagesRequirementNotMet(currentValue.getMessageCount(thresholdLevel), this.value);
    }

    @Override
    public Boolean validateThreshold(PRQAComplianceStatus currentValue, int thresholdLevel) {
        Boolean res = currentValue.getMessageCount(thresholdLevel) <= this.value;
        log.fine(String.format("Found %s mesages, comparing to: %s", currentValue.getMessageCount(thresholdLevel), this.value));
        log.fine(String.format("ValidateThreshold returned %s", res));
        return res;
    }

    @Override
    public Boolean validate(PRQAComplianceStatus lastStableValue, PRQAComplianceStatus currentValue, int thresholdLevel) {
        int msgWithin = currentValue.getMessageCount(thresholdLevel);
        currentValue.setMessagesWithinThreshold(msgWithin);
        if (this.improvement.booleanValue()) {
            return this.validateImprovement(lastStableValue, currentValue, thresholdLevel);
        }
        return this.validateThreshold(currentValue, thresholdLevel);
    }

    @Extension
    public static final class DescriptorImpl
    extends ThresholdSelectionDescriptor<MessageComplianceThreshold> {
        public String getDisplayName() {
            return "Message Compliance Threshold";
        }

        public FormValidation doCheckValue(@QueryParameter String value) {
            try {
                Integer parsedValue = Integer.parseInt(value);
                if (parsedValue < 0) {
                    return FormValidation.error((String)Messages.PRQANotifier_WrongInteger());
                }
            }
            catch (NumberFormatException ex) {
                return FormValidation.error((String)Messages.PRQANotifier_UseNoDecimals());
            }
            return FormValidation.ok();
        }

        public String getHelpFile() {
            return "/plugin/prqa-plugin/config/help-thresholds.html";
        }
    }
}

