/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.text;

import java.util.Objects;
import java.util.function.IntPredicate;

public class TextMatcher {
    private static final int MAX_INT_DIV_10 = 0xCCCCCCC;
    private static final int MAX_INT_MOD_10 = 7;
    private static final int MIN_INT_DIV_10 = -214748364;
    private static final int MIN_INT_MOD_10 = 8;
    private static final long MAX_LONG_DIV_10 = 0xCCCCCCCCCCCCCCCL;
    private static final int MAX_LONG_MOD_10 = 7;
    private static final long MIN_LONG_DIV_10 = -922337203685477580L;
    private static final int MIN_LONG_MOD_10 = 8;
    private static final int MAX_INT_MASK = -268435456;
    private static final long MAX_LONG_MASK = -1152921504606846976L;
    private final char[] text;
    private final int length;
    private int start;
    private int index;

    public TextMatcher(String text) {
        this.text = Objects.requireNonNull(text, "Text must not be null").toCharArray();
        this.length = text.length();
        this.start = 0;
        this.index = 0;
    }

    public char getChar(int index) {
        return this.text[index];
    }

    public int getLength() {
        return this.length;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        if (start < 0 || start > this.length) {
            throw new IndexOutOfBoundsException(String.valueOf(start));
        }
        this.start = start;
        if (this.index < start) {
            this.index = start;
        }
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        if (index < 0 || index > this.length) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        this.index = index;
        if (index < this.start) {
            this.start = index;
        }
    }

    public boolean isAtEnd() {
        return this.index >= this.length;
    }

    public void revert() {
        this.index = this.start;
    }

    public boolean match(char ch) {
        if (this.index >= this.length || this.text[this.index] != ch) {
            return false;
        }
        this.start = this.index++;
        return true;
    }

    public boolean match(CharSequence target) {
        int len = target.length();
        if (this.index + len > this.length) {
            return false;
        }
        int i = this.index;
        for (int j = 0; j < len; ++j) {
            if (this.text[i++] == target.charAt(j)) continue;
            return false;
        }
        return this.success(i);
    }

    private boolean success(int i) {
        this.start = this.index;
        this.index = i;
        return true;
    }

    public boolean matchAny(String any) {
        if (this.index >= this.length) {
            return false;
        }
        if (any.indexOf(this.text[this.index]) < 0) {
            return false;
        }
        this.start = this.index++;
        return true;
    }

    public boolean match(int maxChars, int minChars, IntPredicate comparison) {
        int i;
        int stopper;
        int n = stopper = maxChars > 0 ? Math.min(this.length, i + maxChars) : this.length;
        for (i = this.index; i < stopper && comparison.test(this.text[i]); ++i) {
        }
        if (i - this.index < minChars) {
            return false;
        }
        return this.success(i);
    }

    public boolean match(int maxChars, IntPredicate comparison) {
        return this.match(maxChars, 1, comparison);
    }

    public boolean match(IntPredicate comparison) {
        return this.match(0, 1, comparison);
    }

    public boolean matchDec(int maxDigits, int minDigits) {
        return this.match(maxDigits, minDigits, TextMatcher::isDigit);
    }

    public boolean matchDec(int maxDigits) {
        return this.match(maxDigits, 1, TextMatcher::isDigit);
    }

    public boolean matchDec() {
        return this.match(0, 1, TextMatcher::isDigit);
    }

    public boolean matchHex(int maxDigits, int minDigits) {
        return this.match(maxDigits, minDigits, TextMatcher::isHexDigit);
    }

    public boolean matchHex(int maxDigits) {
        return this.match(maxDigits, 1, TextMatcher::isHexDigit);
    }

    public boolean matchHex() {
        return this.match(0, 1, TextMatcher::isHexDigit);
    }

    public void skipAny(String any) {
        this.start = this.index;
        while (this.index < this.length && any.indexOf(this.text[this.index]) >= 0) {
            ++this.index;
        }
    }

    public void skip(IntPredicate comparison) {
        this.start = this.index;
        while (this.index < this.length && comparison.test(this.text[this.index])) {
            ++this.index;
        }
    }

    public void skipToEnd() {
        this.start = this.index;
        this.index = this.length;
    }

    public void skipFixed(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        int newIndex = this.index + n;
        if (newIndex > this.length) {
            throw new StringIndexOutOfBoundsException(String.valueOf(newIndex));
        }
        this.start = this.index;
        this.index = newIndex;
    }

    public char nextChar() {
        this.start = this.index;
        if (this.index >= this.length) {
            throw new StringIndexOutOfBoundsException(String.valueOf(this.index));
        }
        return this.text[this.index++];
    }

    public String getString(int start, int end) {
        return new String(this.text, start, end - start);
    }

    public CharSequence getCharSeq(int start, int end) {
        if (start < 0 || end > this.length || end < start) {
            throw new IndexOutOfBoundsException(String.valueOf(start) + ':' + end);
        }
        return new CharSeq(this.text, start, end);
    }

    public char getResultChar() {
        return this.text[this.start];
    }

    public String getResult() {
        return new String(this.text, this.start, this.index - this.start);
    }

    public CharSequence getResultCharSeq() {
        return new CharSeq(this.text, this.start, this.index);
    }

    public int getResultLength() {
        return this.index - this.start;
    }

    public int getResultInt() {
        return this.getInt(this.start, this.index, false);
    }

    public int getResultInt(boolean negative) {
        return this.getInt(this.start, this.index, negative);
    }

    public int getInt(int from, int to) {
        return this.getInt(from, to, false);
    }

    public int getInt(int from, int to, boolean negative) {
        if (to <= from) {
            throw new NumberFormatException();
        }
        int result = 0;
        if (negative) {
            for (int i = from; i < to; ++i) {
                int n = TextMatcher.convertDecDigit(this.text[i]);
                if (result < -214748364 || result == -214748364 && n > 8) {
                    throw new NumberFormatException();
                }
                result = result * 10 - n;
            }
        } else {
            for (int i = from; i < to; ++i) {
                int n = TextMatcher.convertDecDigit(this.text[i]);
                if (result > 0xCCCCCCC || result == 0xCCCCCCC && n > 7) {
                    throw new NumberFormatException();
                }
                result = result * 10 + n;
            }
        }
        return result;
    }

    public long getResultLong() {
        return this.getLong(this.start, this.index, false);
    }

    public long getResultLong(boolean negative) {
        return this.getLong(this.start, this.index, negative);
    }

    public long getLong(int from, int to) {
        return this.getLong(from, to, false);
    }

    public long getLong(int from, int to, boolean negative) {
        if (to <= from) {
            throw new NumberFormatException();
        }
        long result = 0L;
        if (negative) {
            for (int i = from; i < to; ++i) {
                int n = TextMatcher.convertDecDigit(this.text[i]);
                if (result < -922337203685477580L || result == -922337203685477580L && n > 8) {
                    throw new NumberFormatException();
                }
                result = result * 10L - (long)n;
            }
        } else {
            for (int i = from; i < to; ++i) {
                int n = TextMatcher.convertDecDigit(this.text[i]);
                if (result > 0xCCCCCCCCCCCCCCCL || result == 0xCCCCCCCCCCCCCCCL && n > 7) {
                    throw new NumberFormatException();
                }
                result = result * 10L + (long)n;
            }
        }
        return result;
    }

    public int getResultHexInt() {
        return this.getHexInt(this.start, this.index);
    }

    public int getHexInt(int from, int to) {
        if (to <= from) {
            throw new NumberFormatException();
        }
        int result = 0;
        for (int i = from; i < to; ++i) {
            if ((result & 0xF0000000) != 0) {
                throw new NumberFormatException();
            }
            result = result << 4 | TextMatcher.convertHexDigit(this.text[i]);
        }
        return result;
    }

    public long getResultHexLong() {
        return this.getHexLong(this.start, this.index);
    }

    public long getHexLong(int from, int to) {
        if (to <= from) {
            throw new NumberFormatException();
        }
        long result = 0L;
        for (int i = from; i < to; ++i) {
            if ((result & 0xF000000000000000L) != 0L) {
                throw new NumberFormatException();
            }
            result = result << 4 | (long)TextMatcher.convertHexDigit(this.text[i]);
        }
        return result;
    }

    private static boolean isDigit(int ch) {
        return ch >= 48 && ch <= 57;
    }

    private static boolean isHexDigit(int ch) {
        return TextMatcher.isDigit(ch) || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102;
    }

    public static int convertDecDigit(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        throw new NumberFormatException("Illegal decimal digit");
    }

    private static int convertHexDigit(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        throw new NumberFormatException("Illegal hexadecimal digit");
    }

    public static class CharSeq
    implements CharSequence {
        private final char[] text;
        private final int start;
        private final int end;

        CharSeq(char[] text, int start, int end) {
            this.text = text;
            this.start = start;
            this.end = end;
        }

        @Override
        public int length() {
            return this.end - this.start;
        }

        @Override
        public char charAt(int index) {
            int i;
            if (index >= 0 && (i = index + this.start) < this.end) {
                return this.text[i];
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            if (start < 0 || end > this.length() || end < start) {
                throw new IndexOutOfBoundsException();
            }
            return new CharSeq(this.text, start + this.start, end + this.start);
        }

        @Override
        public String toString() {
            return new String(this.text, this.start, this.end - this.start);
        }
    }
}

