/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.formatter.jsoup;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;
import net.revelc.code.formatter.AbstractCacheableFormatter;
import net.revelc.code.formatter.ConfigurationSource;
import net.revelc.code.formatter.Formatter;
import net.revelc.code.formatter.LineEnding;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Entities;
import org.jsoup.parser.Parser;

public abstract class JsoupBasedFormatter
extends AbstractCacheableFormatter
implements Formatter {
    private static final Pattern REMOVE_TRAILING_PATTERN = Pattern.compile("\\p{Blank}+$", 8);
    private static final Pattern RESET_LEADING_SPACES_PATTERN = Pattern.compile("^\\s+");
    private Document.OutputSettings formatter;

    @Override
    public void init(Map<String, String> options, ConfigurationSource cfg) {
        super.initCfg(cfg);
        this.formatter = new Document.OutputSettings();
        this.formatter.charset(Charset.forName(options.getOrDefault("charset", StandardCharsets.UTF_8.name())));
        this.formatter.escapeMode(Entities.EscapeMode.valueOf((String)options.getOrDefault("escapeMode", Entities.EscapeMode.xhtml.name())));
        this.formatter.indentAmount(Integer.parseInt(options.getOrDefault("indentAmount", "4")));
        this.formatter.maxPaddingWidth(Integer.parseInt(options.getOrDefault("maxPaddingWidth", "-1")));
        this.formatter.outline(Boolean.parseBoolean(options.getOrDefault("outlineMode", Boolean.TRUE.toString())));
        this.formatter.prettyPrint(Boolean.parseBoolean(options.getOrDefault("pretty", Boolean.TRUE.toString())));
        this.formatter.syntax(Document.OutputSettings.Syntax.valueOf((String)options.getOrDefault("syntax", Document.OutputSettings.Syntax.html.name())));
    }

    @Override
    public String doFormat(String code, LineEnding ending) {
        if (this.formatter.syntax() != Document.OutputSettings.Syntax.html) {
            throw new IllegalArgumentException(this.formatter.syntax() + " is not allowed as syntax");
        }
        Document document = Jsoup.parse((String)code, (String)"", (Parser)Parser.htmlParser());
        document.outputSettings(this.formatter);
        Object formattedCode = document.outerHtml();
        formattedCode = REMOVE_TRAILING_PATTERN.matcher((CharSequence)formattedCode).replaceAll("");
        CharSequence[] lines = ((String)formattedCode).split("\\r?\\n");
        formattedCode = String.join((CharSequence)ending.getChars(), lines);
        if (this.formatter.indentAmount() > 1) {
            lines = ((String)formattedCode).split(ending.getChars());
            ArrayList<CharSequence> newLines = new ArrayList<CharSequence>(lines.length);
            for (CharSequence line : lines) {
                int remainder;
                int trimLineLength;
                int lineLength = ((String)line).length();
                if (lineLength != 0 && lineLength != (trimLineLength = RESET_LEADING_SPACES_PATTERN.matcher(line).replaceAll("").length()) && (remainder = (lineLength - trimLineLength) % this.formatter.indentAmount()) > 0) {
                    line = ((String)line).substring(remainder);
                }
                newLines.add(line);
            }
            formattedCode = String.join((CharSequence)ending.getChars(), newLines);
        }
        if (!((String)(lines = ((String)formattedCode).split(ending.getChars()))[lines.length - 1]).equals(ending.getChars())) {
            formattedCode = (String)formattedCode + ending.getChars();
        }
        if (code.equals(formattedCode)) {
            return null;
        }
        return formattedCode;
    }

    @Override
    public boolean isInitialized() {
        return this.formatter != null;
    }
}

