/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.formatter.xml;

import java.util.Map;
import net.revelc.code.formatter.AbstractCacheableFormatter;
import net.revelc.code.formatter.ConfigurationSource;
import net.revelc.code.formatter.Formatter;
import net.revelc.code.formatter.LineEnding;
import net.revelc.code.formatter.xml.lib.FormattingPreferences;
import net.revelc.code.formatter.xml.lib.XmlDocumentFormatter;

public class XMLFormatter
extends AbstractCacheableFormatter
implements Formatter {
    private XmlDocumentFormatter formatter;

    @Override
    public void init(Map<String, String> options, ConfigurationSource cfg) {
        super.initCfg(cfg);
        FormattingPreferences prefs = new FormattingPreferences();
        prefs.setMaxLineLength(Integer.parseInt(options.getOrDefault("maxLineLength", "120")));
        prefs.setWrapLongLines(Boolean.parseBoolean(options.getOrDefault("wrapLongLines", "true")));
        prefs.setTabInsteadOfSpaces(Boolean.parseBoolean(options.getOrDefault("tabInsteadOfSpaces", "true")));
        prefs.setTabWidth(Integer.parseInt(options.getOrDefault("tabWidth", "4")));
        prefs.setSplitMultiAttrs(Boolean.parseBoolean(options.getOrDefault("splitMultiAttrs", "false")));
        prefs.setWellFormedValidation(options.getOrDefault("wellFormedValidation", "WARN"));
        prefs.setDeleteBlankLines(Boolean.parseBoolean(options.getOrDefault("deleteBlankLines", "false")));
        this.formatter = new XmlDocumentFormatter(options.getOrDefault("lineending", System.lineSeparator()), prefs);
    }

    @Override
    protected String doFormat(String code, LineEnding ending) {
        String formattedCode = this.formatter.format(code);
        if (code.equals(formattedCode)) {
            return null;
        }
        return formattedCode;
    }

    @Override
    public boolean isInitialized() {
        return this.formatter != null;
    }
}

