/*
 * Decompiled with CFR 0.152.
 */
package net.sjr.converterutils;

import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class Java8ConverterUtils {

    public static final class SQLDate {
        @Contract(value="null -> null; !null -> !null")
        @Nullable
        public static java.sql.Date localDateToSqlDate(@Nullable LocalDate value) {
            if (value == null) {
                return null;
            }
            return java.sql.Date.valueOf(value);
        }

        @Contract(value="null -> null; !null -> !null")
        @Nullable
        public static LocalDate sqlDateToLocalDate(@Nullable java.sql.Date value) {
            if (value == null) {
                return null;
            }
            return value.toLocalDate();
        }

        @Contract(value="null -> null; !null -> !null")
        @Nullable
        public static Timestamp localDateTimeToTimestamp(@Nullable LocalDateTime value) {
            if (value == null) {
                return null;
            }
            return Timestamp.valueOf(value);
        }

        @Contract(value="null -> null; !null -> !null")
        @Nullable
        public static LocalDateTime timestampToLocalDateTime(@Nullable Timestamp value) {
            if (value == null) {
                return null;
            }
            return value.toLocalDateTime();
        }

        @Contract(value="null -> null; !null -> !null")
        @Nullable
        public static Time localTimeToSqlTime(@Nullable LocalTime value) {
            if (value == null) {
                return null;
            }
            return Time.valueOf(value);
        }

        @Contract(value="null -> null; !null -> !null")
        @Nullable
        public static LocalTime sqlTimeToLocalTime(@Nullable Time value) {
            if (value == null) {
                return null;
            }
            return value.toLocalTime();
        }
    }

    public static final class SQLString {
        private static final DateTimeFormatter ddMMyyyy = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        private static final DateTimeFormatter ddMMyyyyHHmm = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
        private static final DateTimeFormatter ddMMyyyyHHmmss = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        private static final DateTimeFormatter HHmm = DateTimeFormatter.ofPattern("HH:mm");

        @Contract(value="null -> null; !null -> !null")
        @Nullable
        public static String localDateToString(@Nullable LocalDate d) {
            if (d == null) {
                return null;
            }
            return d.format(ddMMyyyy);
        }

        @Contract(value="null -> null")
        @Nullable
        public static LocalDate stringToLocalDate(@Nullable String s) {
            if (StringUtils.isBlank((CharSequence)s)) {
                return null;
            }
            return LocalDate.parse(s, ddMMyyyy);
        }

        @Contract(value="null -> null; !null -> !null")
        @Nullable
        public static String localDateTimeToString(@Nullable LocalDateTime d) {
            if (d == null) {
                return null;
            }
            return d.format(ddMMyyyyHHmm);
        }

        @Contract(value="null -> null")
        @Nullable
        public static LocalDateTime stringToLocalDateTime(@Nullable String s) {
            if (StringUtils.isBlank((CharSequence)s)) {
                return null;
            }
            return LocalDateTime.parse(s, ddMMyyyyHHmm);
        }

        @Contract(value="null -> null; !null -> !null")
        @Nullable
        public static String localDateTimeToStringWithSeconds(@Nullable LocalDateTime d) {
            if (d == null) {
                return null;
            }
            return d.format(ddMMyyyyHHmmss);
        }

        @Contract(value="null -> null")
        @Nullable
        public static LocalDateTime stringWithSecondsToLocalDateTime(@Nullable String s) {
            if (StringUtils.isBlank((CharSequence)s)) {
                return null;
            }
            return LocalDateTime.parse(s, ddMMyyyyHHmmss);
        }

        @Contract(value="null -> null; !null -> !null")
        @Nullable
        public static String localTimeToString(@Nullable LocalTime d) {
            if (d == null) {
                return null;
            }
            return d.format(HHmm);
        }

        @Contract(value="null -> null")
        @Nullable
        public static LocalTime stringToLocalTime(@Nullable String s) {
            if (StringUtils.isBlank((CharSequence)s)) {
                return null;
            }
            return LocalTime.parse(s, HHmm);
        }
    }

    public static final class PrettyString {
        private static final DateTimeFormatter MMMyyyy = DateTimeFormatter.ofPattern("MMMM yyyy");
        private static final DateTimeFormatter EEddMMyyyy = DateTimeFormatter.ofPattern("EE dd.MM.yyyy");
        private static final DateTimeFormatter ddMMyyyy = DateTimeFormatter.ofPattern("dd.MM.yyyy");
        private static final DateTimeFormatter ddMMyyyyHHmm = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm");
        private static final DateTimeFormatter ddMMyyyyHHmmss = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss");
        private static final DateTimeFormatter HHmm = DateTimeFormatter.ofPattern("HH:mm");

        @Contract(value="null -> null; !null -> !null")
        @Nullable
        public static String localDateToMonthYearString(@Nullable LocalDate d) {
            if (d == null) {
                return null;
            }
            return d.format(MMMyyyy);
        }

        @Contract(value="null -> null")
        @Nullable
        public static LocalDate monthYearStringToLocalDate(@Nullable String s) {
            if (StringUtils.isBlank((CharSequence)s)) {
                return null;
            }
            return LocalDate.parse(s, MMMyyyy);
        }

        @Contract(value="null -> null; !null -> !null")
        @Nullable
        public static String localDateToWeekdayString(@Nullable LocalDate d) {
            if (d == null) {
                return null;
            }
            return d.format(EEddMMyyyy);
        }

        @Contract(value="null -> null")
        @Nullable
        public static LocalDate weekdayStringToLocalDate(@Nullable String s) {
            if (StringUtils.isBlank((CharSequence)s)) {
                return null;
            }
            return LocalDate.parse(s, EEddMMyyyy);
        }

        @Contract(value="null -> null; !null -> !null")
        @Nullable
        public static String localDateToString(@Nullable LocalDate d) {
            if (d == null) {
                return null;
            }
            return d.format(ddMMyyyy);
        }

        @Contract(value="null -> null")
        @Nullable
        public static LocalDate stringToLocalDate(@Nullable String s) {
            if (StringUtils.isBlank((CharSequence)s)) {
                return null;
            }
            return LocalDate.parse(s, ddMMyyyy);
        }

        @Contract(value="null -> null; !null -> !null")
        @Nullable
        public static String localDateTimeToString(@Nullable LocalDateTime d) {
            if (d == null) {
                return null;
            }
            return d.format(ddMMyyyyHHmm);
        }

        @Contract(value="null -> null")
        @Nullable
        public static LocalDateTime stringToLocalDateTime(@Nullable String s) {
            if (StringUtils.isBlank((CharSequence)s)) {
                return null;
            }
            return LocalDateTime.parse(s, ddMMyyyyHHmm);
        }

        @Contract(value="null -> null; !null -> !null")
        @Nullable
        public static String localDateTimeToStringWithSeconds(@Nullable LocalDateTime d) {
            if (d == null) {
                return null;
            }
            return d.format(ddMMyyyyHHmmss);
        }

        @Contract(value="null -> null")
        @Nullable
        public static LocalDateTime stringWithSecondsToLocalDateTime(@Nullable String s) {
            if (StringUtils.isBlank((CharSequence)s)) {
                return null;
            }
            return LocalDateTime.parse(s, ddMMyyyyHHmmss);
        }

        @Contract(value="null -> null; !null -> !null")
        @Nullable
        public static String localTimeToString(@Nullable LocalTime d) {
            if (d == null) {
                return null;
            }
            return d.format(HHmm);
        }

        @Contract(value="null -> null")
        @Nullable
        public static LocalTime stringToLocalTime(@Nullable String s) {
            if (StringUtils.isBlank((CharSequence)s)) {
                return null;
            }
            return LocalTime.parse(s, HHmm);
        }
    }

    public static final class UtilJava8Date {
        @Contract(value="null -> null; !null -> !null")
        @Nullable
        public static LocalDate utilDateToLocalDate(@Nullable Date d) {
            if (d == null) {
                return null;
            }
            return Instant.ofEpochMilli(d.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
        }

        @Contract(value="null -> null; !null -> !null")
        @Nullable
        public static Date localDateToUtilDate(@Nullable LocalDate d) {
            if (d == null) {
                return null;
            }
            return Date.from(d.atStartOfDay(ZoneId.systemDefault()).toInstant());
        }

        @Contract(value="null -> null; !null -> !null")
        @Nullable
        public static LocalDateTime utilDateToLocalDateTime(@Nullable Date d) {
            if (d == null) {
                return null;
            }
            return LocalDateTime.ofInstant(d.toInstant(), ZoneId.systemDefault());
        }

        @Contract(value="null -> null; !null -> !null")
        @Nullable
        public static Date localDateTimeToUtilDate(@Nullable LocalDateTime d) {
            if (d == null) {
                return null;
            }
            return Date.from(d.atZone(ZoneId.systemDefault()).toInstant());
        }

        @Contract(value="null -> null; !null -> !null")
        @Nullable
        public static LocalTime utilDateToLocalTime(@Nullable Date d) {
            if (d == null) {
                return null;
            }
            return Instant.ofEpochMilli(d.getTime()).atZone(ZoneId.systemDefault()).toLocalTime();
        }

        @Contract(value="null -> null; !null -> !null")
        @Nullable
        public static Date localTimeToUtilDate(@Nullable LocalTime d) {
            if (d == null) {
                return null;
            }
            return Date.from(d.atDate(LocalDate.now()).atZone(ZoneId.systemDefault()).toInstant());
        }
    }
}

