/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.buildinfo;

import ch.lambdaj.Lambda;
import com.beust.jcommander.internal.Maps;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.serenitybdd.core.buildinfo.BuildProperties;
import net.serenitybdd.core.buildinfo.DriverCapabilityRecord;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class BuildInfoProvider {
    private final EnvironmentVariables environmentVariables;
    private final DriverCapabilityRecord driverCapabilityRecord;

    public BuildInfoProvider(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.driverCapabilityRecord = (DriverCapabilityRecord)Injectors.getInjector().getInstance(DriverCapabilityRecord.class);
    }

    public BuildProperties getBuildProperties() {
        Map generalProperties = Maps.newHashMap();
        generalProperties.put("Default Driver", ThucydidesSystemProperty.DRIVER.from(this.environmentVariables, "firefox"));
        generalProperties.put("Operating System", System.getProperty("os.name") + " version " + System.getProperty("os.version"));
        this.addRemoteDriverPropertiesTo(generalProperties);
        this.addSaucelabsPropertiesTo(generalProperties);
        this.addCustomPropertiesTo(generalProperties);
        List<String> drivers = this.driverCapabilityRecord.getDrivers();
        Map<String, Properties> driverPropertiesMap = this.driverCapabilityRecord.getDriverCapabilities();
        return new BuildProperties(generalProperties, drivers, driverPropertiesMap);
    }

    private void addRemoteDriverPropertiesTo(Map<String, String> buildProperties) {
        if (ThucydidesSystemProperty.WEBDRIVER_REMOTE_DRIVER.isDefinedIn(this.environmentVariables)) {
            buildProperties.put("Remote driver", ThucydidesSystemProperty.WEBDRIVER_REMOTE_DRIVER.from(this.environmentVariables));
            if (ThucydidesSystemProperty.WEBDRIVER_REMOTE_BROWSER_VERSION.from(this.environmentVariables) != null) {
                buildProperties.put("Remote browser version", ThucydidesSystemProperty.WEBDRIVER_REMOTE_BROWSER_VERSION.from(this.environmentVariables));
            }
            if (ThucydidesSystemProperty.WEBDRIVER_REMOTE_OS.from(this.environmentVariables) != null) {
                buildProperties.put("Remote OS", ThucydidesSystemProperty.WEBDRIVER_REMOTE_OS.from(this.environmentVariables));
            }
        }
    }

    private void addSaucelabsPropertiesTo(Map<String, String> buildProperties) {
        if (ThucydidesSystemProperty.SAUCELABS_URL.isDefinedIn(this.environmentVariables)) {
            buildProperties.put("Saucelabs URL", this.maskAPIKey(ThucydidesSystemProperty.SAUCELABS_URL.from(this.environmentVariables)));
            if (ThucydidesSystemProperty.SAUCELABS_USER_ID.from(this.environmentVariables) != null) {
                buildProperties.put("Saucelabs user", ThucydidesSystemProperty.SAUCELABS_USER_ID.from(this.environmentVariables));
            }
            if (ThucydidesSystemProperty.SAUCELABS_TARGET_PLATFORM.from(this.environmentVariables) != null) {
                buildProperties.put("Saucelabs target platform", ThucydidesSystemProperty.SAUCELABS_TARGET_PLATFORM.from(this.environmentVariables));
            }
            if (ThucydidesSystemProperty.SAUCELABS_DRIVER_VERSION.from(this.environmentVariables) != null) {
                buildProperties.put("Saucelabs driver version", ThucydidesSystemProperty.SAUCELABS_DRIVER_VERSION.from(this.environmentVariables));
            }
            if (ThucydidesSystemProperty.WEBDRIVER_REMOTE_OS.from(this.environmentVariables) != null) {
                buildProperties.put("Remote OS", ThucydidesSystemProperty.WEBDRIVER_REMOTE_OS.from(this.environmentVariables));
            }
        }
    }

    private String maskAPIKey(String url) {
        int apiKeyStart = url.indexOf(":");
        int apiKeyEnd = url.indexOf("@");
        return url.substring(0, apiKeyStart + 3) + "XXXXXXXXXXXXXXXX" + url.substring(apiKeyEnd);
    }

    private void addCustomPropertiesTo(Map<String, String> buildProperties) {
        List sysInfoKeys = Lambda.filter((Matcher)CoreMatchers.startsWith((String)"sysinfo."), this.environmentVariables.getKeys());
        for (String key : sysInfoKeys) {
            String simplifiedKey = key.replace("sysinfo.", "");
            String expression = this.environmentVariables.getProperty(key);
            String value = this.evaluateGroovyExpression(expression);
            buildProperties.put(simplifiedKey, value);
        }
    }

    private String evaluateGroovyExpression(String expression) {
        Binding binding = new Binding();
        binding.setVariable("env", (Object)this.environmentVariables);
        GroovyShell shell = new GroovyShell(binding);
        return shell.evaluate(expression).toString();
    }
}

